*
*            K S R E G 2
*            ***********
*
*       Hermite KS toy code (p.56 & 62) with PN2.5.
*       ------------------------------------------
*
*       Coded by Sverre Aarseth, IOA, Cambridge.
*       ........................................
*
      PROGRAM HERMIT
*
      INCLUDE 'common2.h'
      COMMON/POSTN/  CLIGHT,RZ,GAM,DEGR,IPN
*
*
*       Read input parameters and initialize KS polynomials.
      CALL INPUT
      CALL KSINIT
*
*       Evaluate initial two-body elements.
      SEMI0 = -0.5*BODY(3)/H(1)
      TK = TWOPI*SEMI0*SQRT(SEMI0/BODY(3))
      ECC2 = (1.0 - R(1)/SEMI0)**2 + TDOT2(1)**2/(BODY(3)*SEMI0)
      ECC0 = SQRT(ECC2)
      H0 = H(1)
*
*       Scale output times by Kepler period.
      DELTAT = DELTAT*TK
      TCRIT = TCRIT*TK
      TNEXT = DELTAT
      I1 = 1
*
*       Advance equations of motion until output time is exceeded.
    5 TIME = TIME + STEP(1)
      CALL KSINT(I1)
      IF (MOD(NSTEPU,100).EQ.0) THEN
      ZMU = BODY(1)*BODY(2)/BODY(3)
      WRITE (7,6)  TIME, R(1) ,(ZMU*(H(1)-H0) - DEGR)/(ZMU*H(1)),
     &             DEGR, DTAU(1)
    6 FORMAT (' T R DE/E DEGR DTU ',F10.4,1P,3E12.4,E9.1)
      END IF
      IF (R(1).LT.RZ) STOP
      IF (TIME.LT.TNEXT) GO TO 5
*
*       Perform accuracy check.
      V2 = 0.0
      DO 10 K = 1,4
          V2 = V2 + UDOT(K,1)**2
   10 CONTINUE
*       Form specific energy from regularized expression.
      HT = (2.0*V2 - BODY(3))/R(1)
      SEMI = -0.5*BODY(3)/HT
      ECC2 = (1.0 - R(1)/SEMI)**2 + TDOT2(1)**2/(BODY(3)*SEMI)
      ECC = SQRT(ECC2)
*
*       Print relevant information (note DA/A and DE).
      DA = (SEMI - SEMI0)/SEMI0
      DE = ECC - ECC0
      WRITE (6,20)  TIME/TK, NSTEPU, ECC, SEMI, DA, DE
   20 FORMAT (' T/TK # E A TK DA/A DE ',F8.2,I8,F7.3,1P,3E9.1)
*
      ZMU = BODY(1)*BODY(2)/BODY(3)
      WRITE (8,30)  TIME/TK, R(1) ,(ZMU*(H(1)-H0) - DEGR)/(ZMU*H(1))
   30 FORMAT (' YRS R DE/E  ',1P,E10.2,1P,2E12.4)
      IF (R(1).LT.RZ) STOP
*
*       Continue until termination time is exceeded.
      TNEXT = TNEXT + DELTAT
      IF (TIME.LT.TCRIT) GO TO 5
*
      STOP
*
      END
