      SUBROUTINE PLANET
*
*
*       Energy check and output.
*       ------------------------
*
      INCLUDE 'commonp.h'
      REAL*8  XS(3),XSD(3),SEMI(NMAX),ECC(NMAX),INC(NMAX),OME(NMAX)
      REAL*8  PER(NMAX),W(NMAX),LAM(NMAX),AME(NMAX),XP(2,NMAX),MU
      REAL*8  XX(3,3),VV(3,3),XCM(3),VCM(3),XEQ(3,NMAX)
      REAL*8  ALPHA(NMAX),DELTA(NMAX)
      DATA  KDIM /3/
*
*
*       G in SI units
      G = 6.672D-11 
*       Unit of distance, 1 AU in m
      DU = 1.495978707D11  
*       Unit of mass, solar mass in kg
      MU = 1.988500D+30  
*       Unit of time, mean solar year in s
      TU = 31556736.0
*       Unit of speed, AU per year
      VU = TU / DU
*       G in internal units [G] = L**3 / (M * T**2)
      GN = G * MU * TU * TU / (DU * DU * DU)
*       Obliquity of the ecliptic (J2000)
      EPS = 23.43928
*       One radian in degrees
      R2D = 57.29577951
      D2R = 0.01745329252
      IF (KZ(6).GT.0) THEN
          DO 50 I = 2,N
              RI2 = 0.0
              VI2 = 0.0
              RDOT = 0.0
              DO 45 K = 1,KDIM
                  XS(K) = X(K,I) - X(K,1)
                  XSD(K) = XDOT(K,I) - XDOT(K,1)
                  RI2 = RI2 + XS(K)**2
                  VI2 = VI2 + XSD(K)**2
                  RDOT = RDOT + XS(K)*XSD(K)
   45         CONTINUE
              RI = SQRT(RI2)
              ZMB = BODY(1) + BODY(I)
              SEMI(I) = 2.0/RI - VI2/ZMB
              SEMI(I) = 1.0/SEMI(I)
              ECC2 = (1.0 - RI/SEMI(I))**2 + RDOT**2/(SEMI(I)*ZMB)
              ECC(I) = SQRT(ECC2)
              XHx = XS(2)*XSD(3) - XS(3)*XSD(2)
              XHy = XS(3)*XSD(1) - XS(1)*XSD(3) 
              XHz = XS(1)*XSD(2) - XS(2)*XSD(1)
              XH = XHx * XHx + XHy * XHy + XHz * XHz
              RXD = SQRT(VI2 - XH / RI2)
*
*               Forward integration
*             IF (RDOT.LT.0.0D0) RXD = -RXD
*
*               Backwards integration
              IF (RDOT.GT.0.0D0) RXD = -RXD
              XH = SQRT(XH)
              INC(I) = ACOS(XHz/XH)
*
*               Backwards integration
              INC(I) = 0.5D0 * TWOPI - INC(I)
              OME1 = XHx/(XH * SIN(INC(I)))
              IF (INC(I).LT.0.25D0*TWOPI.AND.XHz.LT.0.0D0) OME1 = -OME1
              IF (INC(I).GT.0.25D0*TWOPI.AND.XHz.GT.0.0D0) OME1 = -OME1
              OME2 = XHy/(XH * SIN(INC(I)))
              IF (INC(I).LT.0.25D0*TWOPI.AND.XHz.GT.0.0D0) OME2 = -OME2
              IF (INC(I).GT.0.25D0*TWOPI.AND.XHz.LT.0.0D0) OME2 = -OME2
              OME(I) = ATAN2(OME1, OME2)
*            IF (I.EQ.4) WRITE(6,*) 'Earth sin cos OME ',OME1, OME2 
*             IF (OME(I).LT.0.0D0) OME(I) = TWOPI + OME(I)
              TX = XS(3) / (RI * SIN(INC(I)))
              TY = (XS(1)/RI + OME1 * TX * COS(INC(I))) / OME2
              WF = ATAN2(TX, TY) 
*              IF (WF.LT.0.0D0) WF = TWOPI + WF
              EF1 = SEMI(I)*(1.0D0-ECC(I)*ECC(I)) * RXD / (XH * ECC(I))
              EF2 = (SEMI(I)*(1.0D0-ECC(I)*ECC(I))/RI-1.0D0)/ECC(I)
              XP(1,I)=RI*EF1
              EF = ATAN2(EF1, EF2) 
*              IF (EF.LT.0.0D0) EF = TWOPI + EF
              XP(2,I)=RI*EF2
              ANE = 2.0D0*ATAN(SQRT((1.0D0-ECC(I))/(1.0D0+ECC(I)))*
     &              TAN(0.5D0*EF))
*              IF (ANE.LT.0.0D0) ANE = TWOPI + ANE 
              AME(I) = ANE-ECC(I)*SIN(ANE)
              IF (AME(I).LT.-0.5D0*TWOPI) AME(I) = TWOPI + AME(I)
              IF (AME(I).GT.0.5D0*TWOPI) AME(I) = AME(I) - TWOPI 
              LAM(I) = R2D * (AME(I)+WF-EF+OME(I))
*             LAM(I) = R2D * (WF-EF+OME(I))
*             IF (WF.LT.0.0D0) WF = TWOPI + WF
*             IF (EF.LT.0.0D0) EF = TWOPI + EF
*             IF (WF.GT.TWOPI) WF = -TWOPI + WF
*             IF (EF.GT.TWOPI) EF = -TWOPI + EF 
              W(I) = R2D * (WF - EF)
              IF (W(I).LT.0.0D0) W(I) = 360.0D0 + W(I)
              IF (LAM(I).LT.-180.0D0) LAM(I) = 360.0D0 + LAM(I)
              IF (LAM(I).GT.180.0D0) LAM(I) = -360.0D0 + LAM(I)   
              INC(I) = R2D * INC(I)
              OME(I) = R2D * OME(I)
              XH = TWOPI**2 * SEMI(I)**3 / (GN * ZMB)
              PER(I) = SQRT(XH) 
              IF (KZ(6).GT.1) WRITE (6,48) I, ECC(I), SEMI(I)
   48         FORMAT (' I ECC A  ',I5,F8.3,F8.3)
   50     CONTINUE
          IF (KZ(6).EQ.1) THEN
              ZMB = BODY(1) + BODY(2)
              DO 60 K = 1,3
                  XX(K,1) = X(K,1)
                  XX(K,2) = X(K,2)
                  XX(K,3) = X(K,3)
                  VV(K,1) = XDOT(K,1)
                  VV(K,2) = XDOT(K,2)
                  VV(K,3) = XDOT(K,3)
                  XCM(K) = (BODY(1)*X(K,1) + BODY(2)*X(K,2))/ZMB
                  VCM(K) = (BODY(1)*XDOT(K,1) + BODY(2)*XDOT(K,2))/ZMB
   60         CONTINUE
              RI2 = 0.0D0
              VI2 = 0.0D0
              DO 61 K = 1,KDIM
                  XS(K) = X(K,11) - X(K,4)
                  XSD(K) = XDOT(K,11) - XDOT(K,4)
                  RI2 = RI2 + XS(K)**2
                  VI2 = VI2 + XSD(K)**2
   61         CONTINUE
              EON = 0.5D0 * VI2 - BODY(4) / SQRT(RI2)
      RE1 = W(11) + OME(11)
      IF (RE1.LT.0.0D0) RE1 = 360.0D0 + RE1
      IF (RE1.GT.360.0D0) RE1 = -360.0D0 + RE1 
      RE2 = W(4) + OME(4)
      IF (RE2.LT.0.0D0) RE2 = 360.0D0 + RE2
      IF (RE2.GT.360.0D0) RE2 = -360.0D0 + RE2
      RE1 = RE1 - RE2
      IF (RE1.LT.0.0D0) RE1 = 360.0D0 + RE1
      IF (RE1.GT.360.0D0) RE1 = -360.0D0 + RE1
      SO = SQRT((X(1,3)-X(1,11))*(X(1,3)-X(1,11))+(X(2,3)-X(2,11))*
     &          (X(2,3)-X(2,11))+(X(3,3)-X(3,11))*(X(3,3)-X(3,11)))
      S1 = SQRT((X(1,4)-X(1,11))*(X(1,4)-X(1,11))+(X(2,4)-X(2,11))*
     &          (X(2,4)-X(2,11))+(X(3,4)-X(3,11))*(X(3,4)-X(3,11)))
      S2 = SQRT((X(1,5)-X(1,11))*(X(1,5)-X(1,11))+(X(2,5)-X(2,11))*
     &          (X(2,5)-X(2,11))+(X(3,5)-X(3,11))*(X(3,5)-X(3,11)))
      S3 = LAM(11) - LAM(4) 
      RBC = SQRT(X(1,11)*X(1,11)+X(2,11)*X(2,11)+X(3,11)*X(3,11))
      VBC = -SQRT(XDOT(1,11)*XDOT(1,11)+XDOT(2,11)*XDOT(2,11)+
     &      XDOT(3,11)*XDOT(3,11))*1.0D-03*DU/TU*TWOPI
      ANG =  LAM(4) * D2R
      XPR = X(1,11) * COS(ANG) + X(2,11) * SIN(ANG)
      YPR = X(2,11) * COS(ANG) - X(1,11) * SIN(ANG)     
      XNX = X(1,4) * COS(ANG) + X(2,4) * SIN(ANG)
      XNY = X(2,4) * COS(ANG) - X(1,4) * SIN(ANG)
      IF (S3.GT.180.0D0) S3 = S3 - 360.0D0
      IF (S3.LT.-180.0D0) S3 = S3 + 360.0D0
      WRITE(8,*) -TIME/TWOPI,SO,S1,S2,RBC,SEMI(11),SEMI(4),
     &           X(1,11),X(2,11),X(3,11),
     &           X(1,4),X(2,4),X(3,4), XPR, YPR, XNX, XNY, EON, RE1 
*             CALL INCLIN(XX,VV,XCM,VCM,ALPHA)
              WRITE (7,*) -TIME/TWOPI, (ECC(I), SEMI(I), INC(I), 
     &                    OME(I), W(I), LAM(I), I = 2, N)
************************************************************************
*
*     Change to Geocentric equatorial rectangular coordinates
      EPS = D2R * EPS
      DO 62 I = 1,N
         XEQ(1,I) = X(1,I)
         XEQ(2,I) = X(2,I) * COS(EPS) - X(3,I) * SIN(EPS)
         XEQ(3,I) = X(2,I) * SIN(EPS) + X(3,I) * COS(EPS)
         ALPHA(I) = 0.0D+00
         DELTA(I) = 0.0D+00
   62 CONTINUE
      DO 63 I = 1,N
         XD1 = XEQ(1,I) - XEQ(1,4)
         XD2 = XEQ(2,I) - XEQ(2,4)
         XD3 = XEQ(3,I) - XEQ(3,4)
         DDD = SQRT(XD1*XD1+XD2*XD2+XD3*XD3)
         IF (I.NE.4) ALPHA(I) = R2D * ATAN2(XD2,XD1)
         IF (ALPHA(I).LT.0.0) ALPHA(I) = ALPHA(I) + 360.0
         IF (I.NE.4) DELTA(I) = R2D * ASIN(XD3/DDD)
   63 CONTINUE
      DALPHA = ALPHA(11) - ALPHA(4)
      IF (DALPHA.GT.360.0) DALPHA = DALPHA - 360.0
      IF (DALPHA.LT.360.0) DALPHA = DALPHA + 360.0
      DALPHA = DALPHA / 15.0D+00
      IF (DALPHA.GT.36.0) DALPHA = DALPHA - 48.0
      IF (DALPHA.GT.24.0) DALPHA = DALPHA - 24.0
*     Backwards
*      IF (DALPHA.GT.5.0) DALPHA = DALPHA - 24.0
*      IF (DALPHA.LT.-24.0) DALPHA = DALPHA + 24.0
*      IF (DALPHA.LT.-16.0) DALPHA = DALPHA + 24.0
      DDELTA = DELTA(11) - DELTA(4)
      ALPHA(11) = ALPHA(11) / 15.0
      ALPHA(4) = ALPHA(4) / 15.0
      WRITE(12,*) -TIME/TWOPI,ALPHA(11),DELTA(11),RBC,VBC,
     &            DALPHA,DDELTA
*
************************************************************************
*              WRITE (7,70)  TIME/TWOPI, (ECC(I), SEMI(I),I=2,N)
*   70         FORMAT (' ',1P,E10.2,0P,3(1X,2F9.4),F8.2)
*  70         FORMAT (' YRS E A  ',1P,E10.2,0P,2(1X,2F9.4),F8.2)
*             CALL FLUSH(7)
*             IF (SEMI(2).LT.0.4.OR.SEMI(2).GT.1.5) THEN
*                 WRITE (6,80) TIME/TWOPI, (ECC(I),SEMI(I),I=2,N), ALPHA
*  80             FORMAT (' UNSTABLE!  ',1P,E10.2,0P,2(1X,2F9.4),F8.2)
*                 IF (KZ(1).GT.0) CALL MYDUMP(1,1)
*                 STOP
*             END IF
          END IF
      END IF
*
      RETURN
*
      END
