      SUBROUTINE STEPK(DT,DTN)
*
*
*       Block time-steps.
*       -----------------
*
      INCLUDE 'common6.h'
      DATA  ONE32 /0.03125/
*     DATA  ONE16,ONE32 /0.0625D0,0.03125/
*
*
*       Truncate any large value to first block-step entry.
      K = 1
      IF (DT.GE.SMAX) GO TO 10
*
*       Compare predicted step with discrete values decreasing by 1/32.
      DT1 = DTK(1)
    1 IF (DT1.GT.DT) THEN
*         DT1 = DT1*ONE16
*         K = K + 4
          DT1 = DT1*ONE32
          K = K + 5
          GO TO 1
      END IF
*
*       Include the case of quantized step (KS block-step version).
    4 IF (DT1.EQ.DT) GO TO 10
*       Increase by 2 until original step is exceeded (then restore level).
      IF (DT1.LT.DT) THEN
          DT1 = 2.0D0*DT1
          K = K - 1
          GO TO 4
      END IF
      K = K + 1
*
*  10 DTN = DTK(K)
   10 CONTINUE
      IF (K.GT.38) THEN
      WRITE (6,12)  K, DT, DT1
   12 FORMAT (' HIGH!!   K DT DT1  ',I10,1P,2E10.2)
      CALL FLUSH(6)
      END IF
      DTN = DTK(K)
*
      RETURN
*
      END
