      SUBROUTINE XVPRED(I1,I2)
*
*
*       Prediction of coordinates & velocities.
*       ---------------------------------------
*
      INCLUDE 'common3.h'
*
*
*       Include fast prediction (order FDOT) for most single particles.
      IF (I2.GE.N) GO TO 20
*       Exclude special cases (I2 < 0: single particle; I1 > N: c.m. body).
      IF (I2.LT.0.OR.I1.GT.N) GO TO 20
*
*       Predict sequential bodies or just one particle (I2 >= I1; I2 = 0).
      I3 = MAX(I1,I2)
      DO 5 I = I1,I3
          S = TIME - T0(I)
          S1 = 1.5*S
          S2 = 2.0*S
          X(1,I) = ((FDOT(1,I)*S + F(1,I))*S + X0DOT(1,I))*S + X0(1,I)
          X(2,I) = ((FDOT(2,I)*S + F(2,I))*S + X0DOT(2,I))*S + X0(2,I)
          X(3,I) = ((FDOT(3,I)*S + F(3,I))*S + X0DOT(3,I))*S + X0(3,I)
          XDOT(1,I) = (FDOT(1,I)*S1 + F(1,I))*S2 + X0DOT(1,I)
          XDOT(2,I) = (FDOT(2,I)*S1 + F(2,I))*S2 + X0DOT(2,I)
          XDOT(3,I) = (FDOT(3,I)*S1 + F(3,I))*S2 + X0DOT(3,I)
    5 CONTINUE
*
*       Resolve the components of any perturbed pairs.
      I = I2
   10 IF (I.GT.N) THEN 
          JPAIR = I - N
          IF (LIST(1,2*JPAIR-1).GT.0) THEN
              CALL RESOLV(JPAIR,1)
          END IF
          I = I - 1
          GO TO 10
      END IF
      GO TO 40
*
*       Set index of first body.
   20 I = I1
*       Predict coordinates & velocities of body #I to order F3DOT.
   25 DT = TIME - T0(I)
      A1 = 0.05D0*DT
      A2 = 0.25D0*DT
      A3 = (T0(I) - T1(I)) + (T0(I) - T2(I))
      DO 30 K = 1,3
          F2DOTK = D3(K,I)*A3 + D2(K,I)
          F3DOTK = D3(K,I)
          X(K,I) = ((((F3DOTK*A1 + ONE12*F2DOTK)*DT + FDOT(K,I))*DT +
     &                             F(K,I))*DT + X0DOT(K,I))*DT + X0(K,I)
          XDOT(K,I) = (((F3DOTK*A2 + ONE3*F2DOTK)*DT +
     &                  3.0D0*FDOT(K,I))*DT + 2.0D0*F(K,I))*DT +
     &                                                        X0DOT(K,I)
   30 CONTINUE
*
*       Resolve the components of perturbed pairs.
      IF (I.GT.N) THEN 
          JPAIR = I - N
          IF (LIST(1,2*JPAIR-1).GT.0) THEN
              CALL RESOLV(JPAIR,1)
          END IF
      END IF
*
*       Check whether more particles need predicting (I2 is last if > 0).
      IF (I2.GT.0) THEN
          I = I + 1
          IF (I.LE.I2) GO TO 25
      END IF
*
   40 RETURN
*
      END
