      SUBROUTINE XTRNL0
*
*
*       External force initialization.
*       ------------------------------
*
      INCLUDE 'common3.h'
*
*
*       Check option for cluster in circular galactic orbit.
      IF (KZ(14).NE.1) GO TO 20
*
*       Specify Oort's constants (units of km/sec/kpc).
      A = 14.4
      B = -12.0
*       Adopt local density from Gilmore & Kuijken (solar mass/pc**3).
      RHO = 0.11
*       Convert rotation constants to units of cm/sec/pc.
      A = 100.0*A
      B = 100.0*B
*
*       Specify the tidal term in star cluster units (solar mass & pc).
      TIDAL(1) = 4.0*A*(A - B)*(PC/GM)
*
*       Initialize the Y-component to zero.
      TIDAL(2) = 0.0
*
*       Specify the vertical force gradient.
      TIDAL(3) = -(2.0*TWOPI*RHO + 2.0*(A - B)*(A + B)*(PC/GM))
*
      FAC = 1.0E-10/(PC/GM)
      WRITE (6,5)  ZMBAR*ZMASS, FAC*TIDAL(1), FAC*TIDAL(3), PC/GM
    5 FORMAT (/,12X,'TOTAL MASS =',F7.1,'  TIDAL(1&3) =',1P,2E10.2,
     &              '  PC/GM =',E10.2)
*
*       Adopt twice the angular velocity for Coriolis terms.
      TIDAL(4) = 2.0*(A - B)*SQRT(PC/GM)
*
*       Scale to working units of RBAR in pc & ZMBAR in solar masses.
      DO 10 K = 1,3
          TIDAL(K) = TIDAL(K)*RBAR**3/ZMBAR
   10 CONTINUE
      TIDAL(4) = TIDAL(4)*SQRT(RBAR**3/ZMBAR)
*
*       Define tidal radius in scaled units.
      RTIDE = (ZMASS/TIDAL(1))**0.3333
*
      WRITE (6,15)  (TIDAL(K),K=1,4), TSCALE, RTIDE
   15 FORMAT (/,12X,'TIDAL PARAMETERS:  ',1P4E10.2,'  TSCALE =',E9.2,
     &                             ' (10**6 YRS)','  RTIDE =',0P,F6.2)
*
*       Consider alternatives: circular point-mass orbit or 3D galaxy model.
   20 ZMTOT = ZMASS*ZMBAR
      IF (KZ(14).EQ.2) THEN
*
*       Read galaxy mass and central distance (solar units and kpc).
          READ (5,*)  GMG, RG0
*
*       Set circular velocity in km/sec and angular velocity in cgs units.
          VG0 = 1.0D-05*SQRT(GMG/(1000.0*RG0))*SQRT(GM/PC)
          OMEGA = 100.0*VG0/RG0
          OMEGA = 1.0
*
*       Obtain King tidal radius in pc (eq. (9) of Fukushige & Heggie, 1995).
          RT = (ZMTOT/(3.0*GMG))**0.3333*RG0
*
          IF (RTIDE.GT.0.0) THEN
*       Determine RBAR (N-body units) from RT (pc) and King model (see SCALE).
              IF(KZ(22).EQ.2) RBAR = RT/RTIDE
          ELSE
              RTIDE = RT/RBAR
          END IF
*
*       Convert from cgs to N-body units.
*         OMEGA = OMEGA*SQRT(PC/GM)*SQRT(RBAR**3/ZMBAR)
*
*       Specify the galactic parameters for equations of motion.
          TIDAL(1) = 3.0*OMEGA**2
          TIDAL(2) = 0.0D0
          TIDAL(3) = -OMEGA**2
          TIDAL(4) = 2.0*OMEGA
*         GMG = GMG/ZMTOT
          WRITE (6,25)  (TIDAL(K),K=1,4)
   25     FORMAT (/,12X,'TIDAL PARAMETERS:   ',1P,4E10.2)
*
*       Check re-scaling units to current RBAR (i.e. TSTAR & VSTAR).
          IF (KZ(22).EQ.2) THEN
              CALL UNITS
          END IF
*
          RTIDE = 0.05
          WRITE (6,35)  GMG, RG0, OMEGA, RTIDE, RBAR
   35     FORMAT (/,12X,'XTRNL0:   GMG RG0 OM RT RB ',1P,5E10.2)
*
*       Perform an energy scaling iteration to include ETIDE (once is OK).
*     E0 = -0.25
*     CALL XTRNLV(1,N)
*       Form total energy based on current values and ETIDE (cf. SCALE).
*     ETOT = ZKIN - POT + ETIDE
*     SX = E0/ETOT
*     IF (ETOT.GE.0.0) SX = 1.0
*
*       Scale coordinates & velocities to yield ETOT = -0.25.
*     DO 24 I = 1,N
*         DO 22 K = 1,3
*             X(K,I) = X(K,I)/SX
*             XDOT(K,I) = XDOT(K,I)*SQRT(SX)
*  22     CONTINUE
*  24 CONTINUE
*
      END IF
*
      RETURN
*
      END
