      SUBROUTINE STEPI(I)
*
*
*       Standard time-step.
*       -------------------
*
      INCLUDE 'common3.h'
      REAL*8  W0(4),W1(4),W2(4),W3(4)
*
*
*       See whether time-step has been set after optional reflection.
      IF (KZ(29).GT.0) THEN
          IF (IPHASE.EQ.8) GO TO 50
      END IF

*       Obtain new irregular integration step using composite expression.
      DT = TIME - T1(I)
      DO 5 K = 1,3
          W0(K) = F(K,I)
          W1(K) = 6.0D0*FDOT(K,I)
          W2(K) = 12.0D0*FDOT2(K,I)
          W3(K) = D3(K,I)
    5 CONTINUE
*
*       Include scaling of derivatives for small steps.
      IF (DT.LE.DTMIN) THEN
          DT2 = DT**2
          DT3 = DT2*DT
          DO 10 K = 1,3
              W1(K) = DT*W1(K)
              W2(K) = DT2*W2(K)
              W3(K) = DT3*W3(K)
   10     CONTINUE
      END IF
*
*       Set square force and derivatives (including factorials).
      W0(4) = W0(1)**2 + W0(2)**2 + W0(3)**2
      W1(4) = W1(1)**2 + W1(2)**2 + W1(3)**2
      W2(4) = W2(1)**2 + W2(2)**2 + W2(3)**2
      W3(4) = W3(1)**2 + W3(2)**2 + W3(3)**2
*
*       Obtain time-step by composite criterion.           
      IF (W3(4).LT.1.0E+20) THEN
          W0(1) = (SQRT(W0(4)*W2(4)) + 0.25*W1(4))/
     &                                   (1.5*SQRT(W1(4)*W3(4)) + W2(4))
*         W0(1) = SQRT(W0(4)/W2(4))
      ELSE
          W0(1) = (SQRT(W0(4)*W2(4)) + 0.25*W1(4))/
     &                             (1.5*SQRT(W1(4))*SQRT(W3(4)) + W2(4))
*         W0(1) = SQRT(W0(4)/W2(4))
      END IF
*       Rescale square time-step for small values.
      IF (DT.LE.DTMIN) THEN
          W0(1) = DT2*W0(1)
      END IF
      W0(1) = ETA*W0(1)
      DTI = SQRT(W0(1))
*
*       Restrict increase of time-step by stability factor 1.2.
      DTI = MIN(DTI,1.2D0*STEP(I))
*
*       Check for step reduction of hierarchical configurations.
      IF (I.GT.N) THEN
          IF (H(I-N).LT.-ECLOSE) THEN
              CALL KEPLER(I,DTI)
          END IF
      END IF
*
*       Check optional step criterion for close encounters.
      IF (KZ(13).GT.0.AND.W0(4).GT.0.25*FCRIT2) THEN
          W2(1) = 1.0/W2(4)
*       Form (FDOT/F2DOT)**2 & 2*ETA*F/F2DOT (note W0(4) = (F/2)**2).
          W2(2) = 0.25*W1(4)*W2(1)
          W3(2) = 2.0*ETA*SQRT(W0(4)*W2(1))
          W3(3) = SQRT(W3(2) + W2(2)) - SQRT(W2(2))
          IF (DT.LE.DTMIN) W3(3) = DT*W3(3)
          IF (DTI.LT.W3(3)) DTI = W3(3)
      END IF
*
*       Check criterion ((F3DOT*DT/6 + F2DOT/2)*DT + FDOT)*DT < 5.0*ETA*F.
      IF (KZ(18).GT.0) THEN
          A1 = SQRT(W1(4))
          A2 = SQRT(W2(4))
          A3 = SQRT(W3(4))
*       Rescale derivatives for small steps.
          IF (DT.LE.DTMIN) THEN
              A1 = A1/DT
              A2 = A2/DT2
              A3 = A3/DT3
          END IF
          IF (TIDAL(1).LE.0.0D0) THEN
              A4 = 10.0*ETA*SQRT(W0(4))
          ELSE
              W0(1) = TIDAL(1)*X(1,I)**2
              A4 = 10.0*ETA*MAX(SQRT(W0(4)),W0(1))
          END IF
          DTC = DTI
          IT = 0
*       Reduce by factor 0.8 until relative force change < 5*ETA (IT < 4).
   30     DFI = ((A3*DTC + A2)*DTC + A1)*DTC
          IF (DFI.GT.A4) THEN
              DTC = 0.8*DTC
              NICONV = NICONV + 1
              IT = IT + 1
              IF (IT.LT.4) GO TO 30
          END IF
          DTI = DTC
      END IF
*     J = NTOT
*     DO 60 K = 1,3
*     RIJ2 = RIJ2 + (X(K,I) - X(K,J))**2
*  60 CONTINUE
*     I1 = 1
*     WRITE (6,65) LIST(1,I1), SQRT(RIJ2)
*  65 FORMAT (' CLOSE??  ',I4,1P,E12.3)
*     CALL FLUSH(6)
*
      STEP(I) = MAX(DTI,5.0D-10)
*
   50 RETURN
*
      END
