      SUBROUTINE SEARCH(I,KCOMP)
*
*
*       Close encounter search.
*       -----------------------
*
      INCLUDE 'common3.h'
      COMMON/CLUMP/   BODYS(NCMAX,5),T0S(5),TS(5),STEPS(5),RMAXS(5),
     &                NAMES(NCMAX,5),ISYS(5)
*
*
*       Increase counter for regularization attempts.
      NCOUNT(7) = NCOUNT(7) + 1
      NKSTRY = NKSTRY + 1
*
*       Predict current velocity of body #I.
      S = TIME - T0(I)
      DO 1 K = 1,3
          XDOT(K,I) = (3.0D0*FDOT(K,I)*S + 2.0D0*F(K,I))*S + X0DOT(K,I)
    1 CONTINUE
*
*       Find dominant neighbour by selecting all STEP(J) < 2*DTMIN.
      FMAX = 0.0
      NCLOSE = 0
*       First see whether any c.m. with small step is within 2*RMIN.
      DO 4 J = NTOT,N+1,-1
          IF (STEP(J).GT.SMIN) GO TO 4
          A1 = X(1,J) - X(1,I)
          A2 = X(2,J) - X(2,I)
          A3 = X(3,J) - X(3,I)
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*
          IF (RIJ2.LT.RMIN22) THEN
              FIJ = BODY(J)/RIJ2
              IF (FMAX.LT.FIJ) FMAX = FIJ
*       Abandon further search if c.m. force exceeds half the total force.
              IF (FMAX**2.LT.F(1,I)**2 + F(2,I)**2 + F(3,I)**2) THEN
                  NCLOSE = NCLOSE + 1
                  JLIST(NCLOSE) = J
                  GO TO 4
              ELSE
                  GO TO 10
              END IF
          END IF
    4 CONTINUE
*
*       Continue searching single particles with current value of FMAX.
      JCOMP = 0
*
      DO 6 J = IFIRST,N
          IF (STEP(J).GT.SMIN.OR.J.EQ.I) GO TO 6
          A1 = X(1,J) - X(1,I)
          A2 = X(2,J) - X(2,I)
          A3 = X(3,J) - X(3,I)
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*
          IF (RIJ2.LT.RMIN22) THEN
              NCLOSE = NCLOSE + 1
              JLIST(NCLOSE) = J
*       Remember index of every single body with small step inside 2*RMIN.
              FIJ = (BODY(I) + BODY(J))/RIJ2
              IF (FIJ.GT.FMAX) THEN
                  FMAX = FIJ
                  RJMIN2 = RIJ2
                  JCOMP = J
*       Global index of dominant body.
              END IF
          END IF
    6 CONTINUE
*
*       See whether dominant component is a single particle inside RMIN.
      IF (JCOMP.LT.IFIRST.OR.JCOMP.GT.N) GO TO 10
      IF (RJMIN2.GT.RMIN2) GO TO 10
*
      RDOT = (X(1,I) - X(1,JCOMP))*(XDOT(1,I) - X0DOT(1,JCOMP)) +
     &       (X(2,I) - X(2,JCOMP))*(XDOT(2,I) - X0DOT(2,JCOMP)) +
     &       (X(3,I) - X(3,JCOMP))*(XDOT(3,I) - X0DOT(3,JCOMP))
*
*       Only select approaching particles (include nearly circular case).
      RIJMIN = SQRT(RJMIN2)
      IF (RDOT.GT.0.1*SQRT((BODY(I) + BODY(JCOMP))*RIJMIN)) GO TO 10
*
*       Evaluate vectorial perturbation due to the close bodies.
      CALL FPERT(I,JCOMP,NCLOSE,PERT)
*
*       Accept #I & JCOMP if the relative motion is dominant (GI < 0.25).
      GI = PERT*RJMIN2/(BODY(I) + BODY(JCOMP))
      IF (GI.GT.0.25) THEN
          IF (KZ(4).GT.0.AND.TIME-TLASTT.GT.4.44*TCR/FLOAT(N))
     &                                             CALL EVOLVE(JCOMP,0)
          GO TO 10
      END IF
*
*       Exclude any c.m. body of compact subsystem (I < N: TRIPLE or QUAD).
      DO 8 ISUB = 1,NSUB
          NAMEI = NAMES(1,ISUB)
          IF (NAMEI.EQ.NAME(I).OR.NAMEI.EQ.NAME(JCOMP)) GO TO 10
    8 CONTINUE
*
*       Also check possible c.m. body of chain regularization (NAME = 0).
      IF (NCH.GT.0) THEN
          IF (NAME(I).EQ.0.OR.NAME(JCOMP).EQ.0) GO TO 10
      END IF
*
*       Save index and predict #JCOMP before integrating ICOMP.
      ICOMP = I
      I = JCOMP
      KCOMP = KCOMP + 1
*
   10 RETURN
*
      END
