      SUBROUTINE MERGE
*
*
*       Merging of hierarchical binary.
*       -------------------------------
*
      INCLUDE 'common3.h'
      COMMON/BINARY/  CM(4,MMAX),XREL(3,MMAX),VREL(3,MMAX),
     &                HM(MMAX),UM(4,MMAX),UMDOT(4,MMAX),
     &                NAMEM(MMAX),NAMEG(MMAX)
*
*
*       COMMON variables for merge procedure
*       ************************************
*
*       ------------------------------------------------------------------
*       CM      Component masses of merged binary (2nd binary in CM(3&4)).
*       HM      Binding energy per unit mass of merged binary.
*       NAMEG   Name of the associated ghost component.
*       NAMEM   Name of new c.m. (< 0) for identification of merger index.
*       NMERG   Total number of mergers.
*       NMERGE  Current number of merged binaries (maximum is MMAX).
*       UM      Regularized coordinates of merged binary.
*       UMDOT   Regularized velocity of merged binary.
*       VREL    Relative velocity of merged binary components.
*       XREL    Relative coordinates of merged binary components.
*       ------------------------------------------------------------------
*
*
*       Check switching of inner and outer binary for improved restart.
      IF (JCOMP.GT.N) THEN
          SEMI2 = -0.5*BODY(JCOMP)/H(JCOMP-N)
          IF (SEMI2.GT.R(KSPAIR)) THEN
              K = KSPAIR
              KSPAIR = JCOMP - N
              JCOMP = N + K
          END IF
      END IF
*
*       Set pair index of inner binary and save index of outer component.
      IPAIR = KSPAIR
      JCOMP1 = JCOMP
*
*       Increase merger counter and set current merger index.
      NCOUNT(24) = NCOUNT(24) + 1
      NMERG = NMERG + 1
      NMERGE = NMERGE + 1
      IMERGE = NMERGE
*
*       Save component masses and evaluate energy of the inner binary.
      CM(1,IMERGE) = BODY(2*IPAIR-1)
      CM(2,IMERGE) = BODY(2*IPAIR)
      EB = BODY(2*IPAIR-1)*BODY(2*IPAIR)*H(IPAIR)/BODY(N+IPAIR)
*
*       Improve coordinates & velocities of the components.
      I = N + IPAIR
      CALL XVPRED(I,0)
      CALL XVPRED(JCOMP,-1)
*
*       Set current energy of any second perturbed binary (from XVPRED).
      IF (JCOMP.GT.N) THEN 
          JPAIR = JCOMP - N
          IF (LIST(1,2*JPAIR-1).GT.0) H(JPAIR) = HT
*       Enforce non-zero membership for potential correction in NBPOT.
          LIST(1,2*JPAIR-1) = 1
*       Ensure that outer binary components are resolved.
          CALL KSRES(JPAIR,J1,J2,0.0D0)
*       Reduce index of outer component if JPAIR moved up at termination.
          IF (IPAIR.LT.JPAIR) THEN
              JPAIR = JPAIR - 1
              JCOMP1 = JCOMP1 - 1
          END IF
      END IF
*
*       Define the primary velocity of JCOMP (needed in KSREG & KSINIT).
      DO 10 K = 1,3
          X0DOT(K,JCOMP) = XDOT(K,JCOMP)
   10 CONTINUE
*
*       Save the perturbers for correction procedure & rename if moved up.
      NNB = LIST(1,2*IPAIR-1)
      DO 20 L = 1,NNB
          J = LIST(L+1,2*IPAIR-1)
          IF (J.GT.I) J = J - 1
          IF (J.LE.2*NPAIRS.AND.J.GT.2*IPAIR) J = J - 2
          JPERT(L) = J
*
*       Reduce steps of perturbers (new force uses c.m. approximation).
          STEP(J) = MAX(0.5D0*STEP(J),TIME - T0(J))
*       Include body #J in the time-step list unless already present.
          IF (T0(J) + STEP(J).LT.TLIST) THEN
              CALL NLMOD(J,1)
          END IF
   20 CONTINUE
*
*       Retain basic KS variables for explicit restart at merge termination.
      HM(IMERGE) = H(IPAIR)
      DO 25 K = 1,4
          UM(K,IMERGE) = U(K,IPAIR)
          UMDOT(K,IMERGE) = UDOT(K,IPAIR)
   25 CONTINUE
*
*       Terminate inner pair in order to merge components after updating.
      CALL KSTERM
*
*       Obtain potential energy with respect to inner components.
      JLIST(1) = ICOMP
      JLIST(2) = JCOMP
      CALL NBPOT(2,NNB,POT1)
*
*       Save relative configuration and define old binary as composite body.
      DO 30 K = 1,3
          XREL(K,IMERGE) = X(K,ICOMP) - X(K,JCOMP)
          VREL(K,IMERGE) = X0DOT(K,ICOMP) - X0DOT(K,JCOMP)
          X(K,ICOMP) = (BODY(ICOMP)*X(K,ICOMP) + BODY(JCOMP)*X(K,JCOMP))
     &                                      /(BODY(ICOMP) + BODY(JCOMP))
          X0DOT(K,ICOMP) = (BODY(ICOMP)*X0DOT(K,ICOMP) +
     &                      BODY(JCOMP)*X0DOT(K,JCOMP))/
     &                                       (BODY(ICOMP) + BODY(JCOMP))
   30 CONTINUE
*
*       Form new c.m. body & associated ghost of zero mass.
      BODY(ICOMP) = BODY(ICOMP) + BODY(JCOMP)
      BODY(JCOMP) = 0.0D0
*
*       Initialize integration variables to prevent spurious predictions.
      DO 40 K = 1,3
          X0DOT(K,JCOMP) = 0.0D0
          XDOT(K,JCOMP) = 0.0D0
          F(K,JCOMP) = 0.0D0
          FDOT(K,JCOMP) = 0.0D0
          FDOT2(K,JCOMP) = 0.0D0
          D2(K,JCOMP) = 0.0D0
          D3(K,JCOMP) = 0.0D0
   40 CONTINUE
*
*       Set large value of T0 which avoids integration of ghost particle.
      T0(JCOMP) = 1.0E+06
*       Set large X0 & X to avoid perturber selection (no escape removal).
      X0(1,JCOMP) = 1.0E+06
      X(1,JCOMP) = 1.0E+06
*
*       See whether modifications due to second binary are needed.
      POT3 = 0.0D0
      POT4 = 0.0D0
      IF (JCOMP1.LE.N) GO TO 50
*
*       Initialize unperturbed ghost binary of outer component.
      T0(2*JPAIR-1) = 1.0E+06
      LIST(1,2*JPAIR-1) = 0
*
*       Apply tidal correction for outer binary perturbers.
      JLIST(1) = 2*JPAIR - 1
      JLIST(2) = 2*JPAIR
      CALL NBPOT(2,NNB,POT3)
      JLIST(1) = JCOMP1
      CALL NBPOT(1,NNB,POT4)
*
*       Update the merger energy to maintain conservation.
      EB1 = BODY(2*JPAIR-1)*BODY(2*JPAIR)*H(JPAIR)/BODY(JCOMP1)
      EMERGE = EMERGE + EB1
*
*       Save component masses and initialize ghost components.
      CM(3,IMERGE) = BODY(2*JPAIR-1)
      CM(4,IMERGE) = BODY(2*JPAIR)
      BODY(2*JPAIR-1) = 0.0D0
      BODY(2*JPAIR) = 0.0D0
*
*       Include interaction of inner c.m. & neighbours to give net effect.
   50 JLIST(1) = ICOMP
      CALL NBPOT(1,NNB,POT2)
*
*       Form square of c.m. velocity correction due to tidal effects.
      VI2 = X0DOT(1,ICOMP)**2 + X0DOT(2,ICOMP)**2 + X0DOT(3,ICOMP)**2
      DPHI = (POT2 - POT1) + (POT4 - POT3)
      CORR = 1.0 + 2.0*DPHI/(BODY(ICOMP)*VI2)
      IF (CORR.LE.0.0D0) CORR = 0.0
*
*       Adjust c.m. velocity by net tidal energy correction.
      DO 60 K = 1,3
          X0DOT(K,ICOMP) = SQRT(CORR)*X0DOT(K,ICOMP)
   60 CONTINUE
*
*       Remove ghost from all perturber lists.
      JLIST(1) = JCOMP
      CALL NBREM(ICOMP,1,NPAIRS)
*
*       Perform KS regularization of hierarchical system (ICOMP & JCOMP1).
      JCOMP = JCOMP1
      CALL KSREG
*
*       Define negative c.m. name for identification & termination.
      NAME(NTOT) = NZERO - NAME(NTOT)
*
*       Set c.m. & ghost names for merger identification (include escape).
      NAMEM(IMERGE) = NAME(NTOT)
      NAMEG(IMERGE) = NAME(JCOMP1)
*
*       Copy stability limit for termination test A(1 - E) < R0 in KSINT.
      R0(NPAIRS) = PCRIT 
*       Ensure that flag denotes new rather than primordial binary.
      LIST(2,JCOMP) = 0
*
*       Modify the merger energy to maintain conservation.
      EMERGE = EMERGE + EB
*
*       Set phase indicator = -1 for new NLIST in routine INTGRT (inactive).
      IPHASE = -1
*
      RETURN
*
      END
