      SUBROUTINE KSMOD(IPAIR,KMOD)
*
*
*       Modified KS motion.
*       -------------------
*
      INCLUDE 'common3.h'
      COMMON/SLOW0/  RANGE,ISLOW(10)
*
*
*       Set current modification level.
      IMOD = KSLOW(IPAIR)
*
*       Check transition type (KMOD <= 1 denotes standard restart).
      IF (KMOD.GT.1) THEN
*       Determine provisional index for KS slow-down.
          DO 5 K = 2,10
              ISBIN = K - 1
              IF (ISLOW(K).GT.KMOD) GO TO 10
    5     CONTINUE
*       Restrict increase to two levels.
   10     ISBIN = MIN(ISBIN,IMOD+2)
*       See whether standard solution is called for.
          IF (ISBIN.EQ.1) GO TO 30
      ELSE
*       Include termination (IMOD > 1 & KMOD <= 1).
          ISBIN = 1
          GO TO 30
      END IF
*
*       Estimate time interval to reach largest permitted perturbation.
      GM = RANGE*GMIN
      CALL TPERT(IPAIR,GM,DT)
*
*       Evaluate the unmodified Kepler period.
      SEMI = -0.5*BODY(N+IPAIR)/H(IPAIR)
      TK = TWOPI*SEMI*SQRT(SEMI/BODY(N+IPAIR))
*
*       Reduce level if modification factor is too large.
      DO 20 K = 2,10
          IF (TK*FLOAT(ISLOW(ISBIN)).LT.DT.OR.ISBIN.EQ.1) GO TO 30
          ISBIN = ISBIN - 1
   20 CONTINUE
*
*       Exit if level is unchanged.
   30 IF (ISBIN.EQ.IMOD) GO TO 100
*
*       Set new KS level and increase restart counter (ISBIN > 1).
      KSLOW(IPAIR) = ISBIN
      IF (ISBIN.GT.1) NCOUNT(25) = NCOUNT(25) + 1
      IF (ISBIN.GT.1) NKSMOD = NKSMOD + 1
*
*       Predict current coordinates & velocities for perturbers & IPAIR.
      I1 = 2*IPAIR - 1
      NNB = LIST(1,I1)
      DO 40 L = 2,NNB+1
          J = LIST(L,I1)
          CALL XVPRED(J,0)
   40 CONTINUE
      CALL RESOLV(IPAIR,1)
*
*       Perform perturbed restart of KS motion.
      CALL KSPOLY(IPAIR,ISBIN)
*
*       Set indicator = -1 to skip perturber selection in routine KSINT.
      KMOD = -1
*
  100 RETURN
*
      END
