      SUBROUTINE KSINIT
*
*
*       Initialization of KS regularization.
*       ------------------------------------
*
      INCLUDE 'common3.h'
      REAL*8  Q(3),RDOT(3),UI(4),A1(3,4)
*
*
*       Set new global indices of the components and current pair index.
      ICOMP = 2*NPAIRS - 1
      JCOMP = ICOMP + 1
      IPAIR = NPAIRS
*
*       Specify mass & name for new c.m. and initialize radius.
      BODY(NTOT) = BODY(ICOMP) + BODY(JCOMP)
      NAME(NTOT) = NZERO + NAME(ICOMP)
      RADIUS(NTOT) = 0.0
      IMOD = 1
*
*       Define c.m. coordinates & velocities and set XDOT for components.
      DO 10 K = 1,3
          X(K,NTOT) = (BODY(ICOMP)*X(K,ICOMP) + BODY(JCOMP)*X(K,JCOMP))/
     &                                                        BODY(NTOT)
          X0DOT(K,NTOT) = (BODY(ICOMP)*X0DOT(K,ICOMP) + BODY(JCOMP)*
     &                                        X0DOT(K,JCOMP))/BODY(NTOT)
          XDOT(K,NTOT) = X0DOT(K,NTOT)
          XDOT(K,ICOMP) = X0DOT(K,ICOMP)
          XDOT(K,JCOMP) = X0DOT(K,JCOMP)
   10 CONTINUE
*
*       Obtain force polynomial for c.m. with components ICOMP & JCOMP.
      JFIRST = JCOMP + 1
*       Avoid prediction of own c.m. for new regularization.
      JLAST = NTOT - 1
*
*       Predict current coordinates & velocities for all other particles.
      CALL XVPRED(JFIRST,JLAST)
*
*       Obtain force polynomials (first F & FDOT, then F2DOT & F3DOT).
      CALL FPOLY1(ICOMP,JCOMP,1)
      CALL FPOLY2(NTOT,NTOT,1)
*
*       See whether to include new c.m. or single components in NLIST.
      IF (T0(NTOT) + STEP(NTOT).LT.TLIST) THEN
          CALL NLMOD(NTOT,1)
      END IF
*
*       Skip KS initialization at merger termination (H, U & UDOT in RESET).
      IF (IPHASE.EQ.7) THEN
          EB = -BODYM*ECLOSE
          GO TO 50
      END IF
*
*       Define relative coordinates and velocities in physical units.
      DO 20 K = 1,3
          Q(K) = X(K,ICOMP) - X(K,JCOMP)
          RDOT(K) = X0DOT(K,ICOMP) - X0DOT(K,JCOMP)
   20 CONTINUE
*
*       Introduce regularized variables using definition of 1985 paper.
      R(IPAIR) = SQRT(Q(1)**2 + Q(2)**2 + Q(3)**2)
*
*       Initialize the regularized coordinates according to sign of Q(1).
      IF (Q(1).LE.0.0D0) THEN
          UI(3) = 0.0D0
          UI(2) = SQRT(0.5D0*(R(IPAIR) - Q(1)))
          UI(1) = 0.5D0*Q(2)/UI(2)
          UI(4) = 0.5D0*Q(3)/UI(2)
      ELSE
          UI(4) = 0.0D0
          UI(1) = SQRT(0.5D0*(R(IPAIR) + Q(1)))
          UI(2) = 0.5D0*Q(2)/UI(1)
          UI(3) = 0.5D0*Q(3)/UI(1)
      END IF
*
*       Set current transformation matrix.
      CALL MATRIX(UI,A1)
*
*       Form regularized velocity and set initial KS coordinates & TDOT2.
      TDOT2(IPAIR) = 0.0D0
      DO 30 K = 1,4
          UDOT(K,IPAIR) = 0.50D0*(A1(1,K)*RDOT(1) + A1(2,K)*RDOT(2) +
     &                                                  A1(3,K)*RDOT(3))
*       Note that A1(J,K) is the transpose of A1(K,J).
          U(K,IPAIR) = UI(K)
          U0(K,IPAIR) = U(K,IPAIR)
          TDOT2(IPAIR) = TDOT2(IPAIR) + 2.0D0*UI(K)*UDOT(K,IPAIR)
   30 CONTINUE
*
*       Evaluate initial binding energy per unit mass and EB.
      H(IPAIR) = (2.0D0*(UDOT(1,IPAIR)**2 + UDOT(2,IPAIR)**2 +
     &                   UDOT(3,IPAIR)**2 + UDOT(4,IPAIR)**2) -
     &                                              BODY(NTOT))/R(IPAIR)
      EB = H(IPAIR)*BODY(ICOMP)*BODY(JCOMP)/BODY(NTOT)
*
*       Form perturber list.
   50 CALL KSLIST(IPAIR)
*
*       Avoid initial unperturbed motion (cf. apocentre procedure). 
      IF (LIST(1,ICOMP).EQ.0) THEN
          IF (IPHASE.NE.7) THEN
              LIST(1,ICOMP) = 1
              LIST(2,ICOMP) = IFIRST
          END IF
*       Estimate an appropriate KS slow-down index for G < GMIN.
          SEMI = -0.5*BODY(NTOT)/H(IPAIR)
          TK = TWOPI*ABS(SEMI)*SQRT(ABS(SEMI)/BODY(NTOT))
          IF (KZ(26).GT.0.AND.STEP(NTOT).GT.TK) THEN
              IMOD = 1 + LOG(STEP(NTOT)/TK)/0.69
              IMOD = MIN(IMOD,5)
          END IF
      END IF
*
*       Specify zero membership and large step for second component.
      LIST(1,JCOMP) = 0
      STEP(JCOMP) = 1.0E+06
*
*       Obtain polynomials for perturbed KS motion (standard case).
      CALL KSPOLY(IPAIR,IMOD)
*
*       Set maximum of RMIN & 2*SEMI as termination scale for hard binary.
      IF (EB.LT.-0.5*BODYM*ECLOSE) THEN 
          R0(IPAIR) = MAX(RMIN,-BODY(NTOT)/H(IPAIR))
      ELSE
          R0(IPAIR) = R(IPAIR)
      END IF
*
*       Increase regularization counters (#9 & NKSHYP for hyperbolic orbits).
      NCOUNT(8) = NCOUNT(8) + 1
      NKSREG = NKSREG + 1
      IF (H(IPAIR).GT.0.0) NCOUNT(9) = NCOUNT(9) + 1
      IF (H(IPAIR).GT.0.0) NKSHYP = NKSHYP + 1
*
      IF (KZ(10).GT.0) THEN
          RI = SQRT((X(1,NTOT) - RDENS(1))**2 +
     &              (X(2,NTOT) - RDENS(2))**2 +
     &              (X(3,NTOT) - RDENS(3))**2)
          WRITE (6,60)  TIME, NAME(ICOMP), NAME(JCOMP), DTAU(IPAIR),
     &                  R(IPAIR), RI, H(IPAIR), IPAIR, GAMMA(IPAIR),
     &                  STEP(NTOT), LIST(1,ICOMP)
   60     FORMAT (/,' NEW KSREG    TIME =',F7.2,2I6,F12.3,1PE10.1,
     &                                   0PF7.2,F9.2,I4,F8.3,1PE10.1,I5)
      END IF
*
*       Modify the termination criterion according to value of NPAIRS.
      IF (NPAIRS.GT.KMAX - 3) GMAX = 0.8*GMAX
      IF (NPAIRS.LT.KMAX - 5.AND.GMAX.LT.0.001) GMAX = 1.2*GMAX
      IF (NPAIRS.EQ.KMAX) WRITE (6,70)  NPAIRS, TIME
   70 FORMAT (5X,'WARNING!   MAXIMUM KS PAIRS   NPAIRS TIME',I5,F8.2)
*
*       See whether either component has been regularized recently.
      NNB = LISTD(1) + 1
      K = 0
*       Check case of initial binary and loop over disrupted pairs.
      IF (IABS(NAME(ICOMP) - NAME(JCOMP)).EQ.1) K = -1
      DO 80 L = 2,NNB
          IF (NAME(ICOMP).EQ.LISTD(L).OR.NAME(JCOMP).EQ.LISTD(L)) K = -1
   80 CONTINUE
*
*       Ensure that mergers are treated as new binaries.
      IF (IPHASE.EQ.6) K = 0
*       Set flags to distinguish primordial binaries & standard KS motion.
      LIST(2,JCOMP) = K
      KSLOW(IPAIR) = 1
*
*       Check diagnostic output of new hard binary.
      IF (KZ(8).GT.0.AND.K.EQ.0) THEN
          IF (EB.GT.-0.5*BODYM*ECLOSE) GO TO 100
          SEMI = -0.5*BODY(NTOT)/H(IPAIR)
          RI = SQRT((X(1,NTOT) - RDENS(1))**2 +
     &              (X(2,NTOT) - RDENS(2))**2 +
     &              (X(3,NTOT) - RDENS(3))**2)
          IF (IPHASE.EQ.6) K = -1
          WRITE (8,90)  TIME, NAME(ICOMP), NAME(JCOMP), K, BODY(ICOMP),
     &                  BODY(JCOMP), EB, SEMI, R(IPAIR), GAMMA(IPAIR),
     &                  RI
   90     FORMAT (' NEW BINARY   T =',F6.1,'  NAME = ',2I4,I3,
     &                        '  M =',2F6.2,'  EB =',F9.4,'  A =',F7.4,
     &                          '  R =',F7.4,'  G =',F6.3,'  RI =',F5.2) 
      END IF
*
  100 RETURN
*
      END
