      SUBROUTINE KSAPO(IPAIR)
*
*
*       Apocentre/pericentre KS variables.
*       ----------------------------------
*
      INCLUDE 'common3.h'
*
*
*       Form product of KS frequency and half regularized period (= PI/2).
      THETA = 0.25D0*TWOPI
*     RP = R(IPAIR)
*
*       Specify transformation coefficients (Stiefel & Scheifele p. 85).
      XC = COS(THETA)
      YS = SIN(THETA)
      FF = SQRT(0.5D0*ABS(H(IPAIR)))
      R(IPAIR) = 0.0D0
      TDOT2(IPAIR) = 0.0D0
*
*       Generate analytical solutions for U & UDOT using old U0 & UDOT.
      DO 10 K = 1,4
          U(K,IPAIR) = U0(K,IPAIR)*XC + UDOT(K,IPAIR)*YS/FF
          UDOT(K,IPAIR) = UDOT(K,IPAIR)*XC - U0(K,IPAIR)*YS*FF
          U0(K,IPAIR) = U(K,IPAIR)
          R(IPAIR) = R(IPAIR) + U(K,IPAIR)**2
          TDOT2(IPAIR) = TDOT2(IPAIR) + 2.0D0*U(K,IPAIR)*UDOT(K,IPAIR)
   10 CONTINUE
*
*       Impose R' < 0 for apocentre procedures.
      IF (TDOT2(IPAIR).GT.0.0D0) THEN
          TDOT2(IPAIR) = -1.0E-10
      END IF
*
*       Ensure unperturbed motion after polynomial initialization.
      LIST(1,2*IPAIR-1) = 0
*
*       Include diagnostic check that correct apocentre has been set.
*     SEMI = -0.5D0*BODY(N+IPAIR)/H(IPAIR)
*     WRITE (6,20)  SEMI, RP, R(IPAIR), H(IPAIR), GAMMA(IPAIR)
*  20 FORMAT (' APOCENTRE:    A RP RA H G ',1P,3E10.2,2E10.1)
*
      RETURN
*
      END
