      SUBROUTINE INTGRT
*
*
*       N-body integrator flow control.
*       -------------------------------
*
      INCLUDE 'common3.h'
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      COMMON/CLUMP/   BODYS(NCMAX,5),T0S(5),TS(5),STEPS(5),RMAXS(5),
     &                NAMES(NCMAX,5),ISYS(5)
      COMMON/EXTRA2/ TINJ,DTINJ,RT,KX,NIN
      SAVE ISTART
      DATA ISTART /0/
*
*
      IF (NSTEPI.EQ.0) THEN
          READ (5,*)  TINJ, DTINJ
          WRITE (6,99)  TINJ, DTINJ
   99     FORMAT (' BEGIN    TINJ DT ',2F8.2)
      END IF
*
*       Ensure new NLIST for negative phase indicator.
      IF (IPHASE.LT.0) THEN
          IPHASE = 0
          TLIST = TLIST - DTLIST
          GO TO 4
      ELSE
          IPHASE = 0
      END IF
*
*       Find next body to be advanced and set new time.
    1 NNB = NLIST(1) + 1
      TNEW = 1.0D+10
*
      DO 2 L = 2,NNB
          J = NLIST(L)
          A2 = T0(J) + STEP(J)
          IF (A2.LT.TNEW) THEN
              I = J
              TNEW = A2
          END IF
    2 CONTINUE
*
      TIME = TNEW
*       Start integration cycle unless new time-step list is required.
      IF (TIME.LT.TLIST) GO TO 10
*
*       Form new time-step list and redetermine next body to be treated.
    4 NL = 1
      TLIST = TLIST + DTLIST
*
      DO 5 J = 1,NTOT
          IF (T0(J) + STEP(J).LT.TLIST) THEN 
              NL = NL + 1
              NLIST(NL) = J 
          END IF
    5 CONTINUE
*
      IF (NL.EQ.1) GO TO 4 
      NLIST(1) = NL - 1 
*       Stabilize membership of NLIST on square root of N.
      IF (NL.GT.NSTABL)     DTLIST = 0.75*DTLIST
      IF (NL.LT.0.5*NSTABL) DTLIST = 1.25*DTLIST
      GO TO 1
*
*       Decide the appropriate integration method.
   10 IF (I.LT.IFIRST) THEN
      JJ = 55
      IF (NAME(JJ).EQ.0) THEN
      WRITE (6,209) I, IPHASE
  209 FORMAT (' ZERO2     I IPH ',2I5)
      STOP
      END IF
          CALL KSINT(I)
*       Check for termination, multiple regularization or merger.
          IF (IPHASE.GT.0) GO TO 100
*
      ELSE
          CALL NBINT(I)
*       Check for new KS regularization.
          IF (IPHASE.EQ.1) GO TO 100
*
*       Obtain new step at end of direct integration cycle.
          CALL STEPI(I) 
      END IF
*     IF (MOD(NSTEPI,1000).EQ.0) WRITE (6,200) I,TIME, NSTEPI,
*    &                    NSTEPU, STEP(I)
* 200 FORMAT (' INTGRT   I T #I #U SI  ',I5,F9.4,2I8,1P,E10.2)
*     CALL FLUSH(6)
*
      IF (KZ(11).GT.0.AND.TIME.GT.TINJ.AND.IPHASE.NE.8) THEN
          CALL INJECT
      END IF
      JJ = 55
      IF (NAME(JJ).EQ.0) THEN
      WRITE (6,247) NAME(JJ)
  247 FORMAT (' ZERO3 INTGRT   ',I5)
      STOP
      END IF
*
*       Check next adjust time at the end of each integration cycle.
      IF (TIME.GT.TADJ) THEN
          IPHASE = 3
*       Indicator for calling ADJUST from MAIN (permits phase overlay).
          GO TO 100
      END IF
*
*       Also check output time in case DTADJ & DELTAT not commensurate.
      IF (TIME.GT.TNEXT) THEN
          CALL OUTPUT
      END IF
*
      JJ = 55
      IF (NAME(JJ).EQ.0) THEN
      WRITE (6,246) NAME(JJ)
  246 FORMAT (' ZERO2 INTGRT   ',I5)
      STOP
      END IF
*       Check time for advancing any triple or quad regularization.
      IF (NSUB.GT.0) THEN
          TSUB = 1.0D+10
          DO 30 L = 1,NSUB
              IF (TS(L).LT.TSUB) THEN
                  ISUB = L
                  TSUB = TS(L)
              END IF
   30     CONTINUE
*
          IF (TSUB.LT.TIME) THEN
*       Decide between triple, quad or chain.
              IF (ISYS(ISUB).EQ.1) THEN
*       Update unperturbed size of subsystem and copy c.m. step.
                  CALL EXTEND(ISUB)
                  CALL TRIPLE(ISUB)
              ELSE IF (ISYS(ISUB).EQ.2) THEN
                  CALL EXTEND(ISUB)
                  CALL QUAD(ISUB)
              ELSE
*       Update perturbed size of subsystem after advancing chain c.m.
                  TIME = TSUB
*                 CALL EXTEND(ISUB)
                  CALL TCHAIN(ISUB,TSMIN)
                  CALL CHAIN(ISUB)
              END IF
          END IF
      END IF
*
*       Advance counters and check timer & optional COMMON save.
      NTIMER = NTIMER + 1
      IF (NTIMER.LT.NMAX) GO TO 1
      NTIMER = 0
      NSTEPS = NSTEPS + NMAX
*
      IF (NSTEPS.GE.100*NMAX) THEN
          NSTEPS = 0
          IF (KZ(1).GT.1) CALL MYDUMP(1,1)
      END IF
*
*       Check option for general binary search.
      IF (KZ(4).GT.0.AND.TIME - TLASTS.GT.DELTAS) THEN  
          CALL EVOLVE(0,0)
      END IF
*
*       Include facility for termination of run (create dummy file STOP).
      OPEN (99,FILE='STOP',STATUS='OLD',FORM='FORMATTED',IOSTAT=IO)
      IF (IO.EQ.0) THEN
          CLOSE (99)
          IF (NSUB.EQ.0) WRITE (6,35)
   35     FORMAT  (/,9X,'TERMINATION BY MANUAL INTERVENTION')
          CPU = 0.0
      END IF
*
*       Repeat cycle until elapsed computing time exceeds the limit.
      CALL CPUTIM(TCOMP)
      IF (TCOMP.LT.CPU) GO TO 1
*
*       Do not terminate during triple, quad or chain regularization.
      IF (NSUB.GT.0) THEN
*       Specify zero step to enforce termination.
          DO 38 L = 1,NSUB
              STEPS(ISUB) = 0.0D0
   38     CONTINUE
          NTIMER = NMAX
          GO TO 1
      END IF
*
*       Terminate run with optional COMMON save.
      IF (KZ(1).GT.0) THEN
          CPUTOT = CPUTOT + TCOMP - CPU0
          CALL MYDUMP(1,1)
          WRITE (6,40)  TIME, TCOMP, CPUTOT/60.0, ERRTOT, DETOT
   40     FORMAT (//,9X,'COMMON SAVED AT TIME =',F8.2,'  TCOMP =',F7.1,
     &                  '  CPUTOT =',F6.1,'  ERRTOT =',F10.6,
     &                  '  DETOT =',F10.6)
          STOP
      END IF
*
  100 RETURN
*
      END
