      SUBROUTINE DRAG(I,FIRR)
*
*
*       Cluster drag force.
*       -------------------
*
      INCLUDE 'common3.h'
      REAL*8  FIRR(3)
*
*
      VI2 = XDOT(1,I)**2 + XDOT(2,I)**2 + XDOT(3,I)**2
      GAS = 1.0D-02
      CLM = 1.0E-03
      XM = 1.0/FLOAT(N)
      HM = 1.0E-02
*       Set normalized stellar velocity.
      VI2 = VI2*CLM/HM
      FDRAG = -10.0*GAS*XM*(VI2 + 1.0)**1.5
      FDRAG = SQRT(CLM/HM**3)*FDRAG
*
      IF (NSTEPI.LT.100) WRITE (6,5)  I, VI2, FDRAG, FIRR
    5 FORMAT (' DRAG   I V2 FD FI ',I6,1P,5E10.2)
      DO 10 K = 1,3
          FIRR(K) = FIRR(K) + FDRAG*XDOT(K,I)
   10 CONTINUE
*
      RETURN
*
      END
