      SUBROUTINE DERQP4(P,Q,DP,DQ)
*
*
*       Equations of motion for chain regularization.
*       ---------------------------------------------
*
      IMPLICIT REAL*8  (A-H,O-Z)
      REAL*8  M,MIJ,XNR(9),FNR(9),WI(9),AT(3),AQ(3),AP(9),FQ(9),WP(9),
     &        P(12),Q(12),DP(12),DQ(13)
      LOGICAL  SWITCH,GTYPE,GTYPE0
      COMMON/CREG/  M(4),X(12),XD(12),PP(12),QQ(12),TIME4,ENERGY,EPSR2,
     &              XR(9),W(9),R(6),TA(6),MIJ(6),CM(10),RMAX4,TMAX,
     &              DS,TSTEP,EPS,NSTEP4,NAME4(4),KZ15,NREG,NFN
      COMMON/TPR/   SWITCH,GTYPE,GTYPE0
      COMMON/CONFIG/  R2(4,4),I1,I2,I3,I4
      COMMON/CLOSE/  RIJ(4,4),RCOLL,QPERI,SIZE(4),ECOLL3
      COMMON/CCOLL/  QK(12),PK(12),ICALL,ICOLL
      COMMON/BSSAVE/  EP(4),DSC,FACM,TFAC,ITFAC,JC
      EQUIVALENCE  (T11,TA(1)),(T22,TA(2)),(T33,TA(3)),(T12,TA(4)),
     &             (T23,TA(5))
*     EQUIVALENCE  (M12,MIJ(1)),(M23,MIJ(2)),(M34,MIJ(3)),
*    &             (M13,MIJ(4)),(M24,MIJ(5)),(M14,MIJ(6))
*
*
      NFN = NFN + 1
      K = 0
      KP = 0
      DO 1 L = 1,3
          K1 = K + 1
          K2 = K + 2
          K3 = K + 3
          K4 = K + 4
          KP1 = KP + 1
          KP2 = KP + 2
          KP3 = KP + 3
*
*       Form physical vector & scalar distance.
          XR(KP1) = Q(K1)**2 - Q(K2)**2 - Q(K3)**2 + Q(K4)**2
          XR(KP2) = 2.D0*(Q(K1)*Q(K2) - Q(K3)*Q(K4))
          XR(KP3) = 2.D0*(Q(K1)*Q(K3) + Q(K2)*Q(K4))
          R(L) = Q(K1)**2 + Q(K2)**2 + Q(K3)**2 + Q(K4)**2
*       Set physical momentum times distance.
          WI(KP1) = Q(K1)*P(K1) - Q(K2)*P(K2) - Q(K3)*P(K3) +
     &                                          Q(K4)*P(K4)
          WI(KP2) = Q(K2)*P(K1) + Q(K1)*P(K2) - Q(K4)*P(K3) -
     &                                          Q(K3)*P(K4)
          WI(KP3) = Q(K3)*P(K1) + Q(K4)*P(K2) + Q(K1)*P(K3) +
     &                                          Q(K2)*P(K4)
          AT(L) = TA(L)*(P(K1)**2 + P(K2)**2 + P(K3)**2 +
     &                                         P(K4)**2) - MIJ(L)
          K = K4
          KP = KP3
    1 CONTINUE
*
*       Obtain irregular vectors & distances.
      R(4) = 0.
      R(5) = 0.
      R(6) = 0.
      DO 2 K = 1,3
          XNR(K  ) = XR(K  ) + XR(K+3)
          XNR(K+3) = XR(K+3) + XR(K+6)
          XNR(K+6) = XNR(K ) + XR(K+6)
          R(4) = R(4) + XNR(K  )**2
          R(5) = R(5) + XNR(K+3)**2
          R(6) = R(6) + XNR(K+6)**2
    2 CONTINUE
*
*       Evaluate irregular physical forces.
      UNR = 0.
      DO 5 I = 4,6
          DIST = SQRT(R(I))
          FC = MIJ(I)/DIST
          UNR = UNR + FC
          FC = FC/R(I)
          R(I) = DIST
          IK = (I - 4)*3
          DO 3 K = 1,3
              FNR(IK+K) = FC*XNR(IK+K)
    3     CONTINUE
    5 CONTINUE
      W1W2 = WI(1)*WI(4) + WI(2)*WI(5) + WI(3)*WI(6)
      W2W3 = WI(4)*WI(7) + WI(5)*WI(8) + WI(6)*WI(9)
      UNRE = UNR + ENERGY
      R12 = R(1)*R(2)
      R13 = R(1)*R(3)
      R23 = R(2)*R(3)
      AQ(1) = AT(2)*R(3) + AT(3)*R(2) + T23*W2W3-R23*UNRE
      AQ(2) = AT(1)*R(3) + AT(3)*R(1) - R13*UNRE
      AQ(3) = AT(2)*R(1) + AT(1)*R(2) + T12*W1W2-R12*UNRE
      R123 = R12*R(3)
      AP(1) = 2.0D0*T11*R23
      AP(2) = 2.0D0*T22*R13
      AP(3) = 2.0D0*T33*R12
      DO 6 K = 1,3
          WP(K  ) = T12*R(3)*WI(K+3)
          WP(K+3) = T12*R(3)*WI(K  ) + T23*R(1)*WI(K+6)
          WP(K+6) = T23*R(1)*WI(K+3)
          FQ(K  ) = FNR(K  ) + FNR(K+6)
          FQ(K+3) = FNR(K  ) + FNR(K+3) + FNR(K+6)
          FQ(K+6) = FNR(K+3) + FNR(K+6)
6     CONTINUE
*
*       Form regularized derivatives.
      KQ = 0
      L = 0
*
      DO 10 I = 1,3
          K1 = KQ + 1
          K2 = KQ + 2
          K3 = KQ + 3
          K4 = KQ + 4
*
          L1 = L + 1
          L2 = L + 2
          L3 = L + 3
*
          F1 = +FQ(L1)*Q(K1) + FQ(L2)*Q(K2) + FQ(L3)*Q(K3)
          F2 = -FQ(L1)*Q(K2) + FQ(L2)*Q(K1) + FQ(L3)*Q(K4)
          F3 = -FQ(L1)*Q(K3) - FQ(L2)*Q(K4) + FQ(L3)*Q(K1)
          F4 = +FQ(L1)*Q(K4) - FQ(L2)*Q(K3) + FQ(L3)*Q(K2)
*
          G1 = +WP(L1)*P(K1) + WP(L2)*P(K2) + WP(L3)*P(K3)
          G2 = -WP(L1)*P(K2) + WP(L2)*P(K1) + WP(L3)*P(K4)
          G3 = -WP(L1)*P(K3) - WP(L2)*P(K4) + WP(L3)*P(K1)
          G4 = +WP(L1)*P(K4) - WP(L2)*P(K3) + WP(L3)*P(K2)
*
          RRR = R123 + R123
          DP(K1) = -(2.D0*AQ(I)*Q(K1) + G1+RRR*F1)
          DP(K2) = -(2.D0*AQ(I)*Q(K2) + G2+RRR*F2)
          DP(K3) = -(2.D0*AQ(I)*Q(K3) + G3+RRR*F3)
          DP(K4) = -(2.D0*AQ(I)*Q(K4) + G4+RRR*F4)
*
          G1 = +WP(L1)*Q(K1) + WP(L2)*Q(K2) + WP(L3)*Q(K3)
          G2 = -WP(L1)*Q(K2) + WP(L2)*Q(K1) + WP(L3)*Q(K4)
          G3 = -WP(L1)*Q(K3) - WP(L2)*Q(K4) + WP(L3)*Q(K1)
          G4 = +WP(L1)*Q(K4) - WP(L2)*Q(K3) + WP(L3)*Q(K2)
*
          DQ(K1) = AP(I)*P(K1) + G1
          DQ(K2) = AP(I)*P(K2) + G2
          DQ(K3) = AP(I)*P(K3) + G3
          DQ(K4) = AP(I)*P(K4) + G4
*
          KQ = KQ + 4
          L = L + 3
   10 CONTINUE
*
*       Set the time derivative and check tolerance scaling (ITFAC > 1).
      DQ(13) = R123
      IF (ITFAC.GT.0) THEN
          TFAC = FACM*(R(1)*R(2) + R(1)*R(3) + R(2)*R(3))
          ITFAC = -1
      END IF
*
*       Procedure for obtaining GAMMA (only after first call).
*     IF (IDIAG.EQ.1) THEN
*         GAMMA  =  AT(1)*R23 + AT(2)*R13 + AT(3)*R12 +
*    &              (R(3)*T12*W1W2 + t23*R(1)*W2W3) - R123*UNRE
*         IDIAG  =  0
*       NB! IDIAG must be in COMMON and set > 0 by RCHAIN.
*     END IF
*
      IF (GTYPE) THEN
*       Use modified time transformation for critical case.
          GAMMA = AT(1)*R23 + AT(2)*R13 + AT(3)*R12 +
     &            R(3)*T12*W1W2 + T23*R(1)*W2W3 - R123*UNRE
          SIGIN = 1.D0/(R12 + R23 + R13)
          GSIGIN = 2.D0*GAMMA*SIGIN
          SUMR = R(1) + R(2) + R(3)
          DO 15 I = 1,3
              SI = (SUMR - R(I))*GSIGIN
              KQ = (I - 1)*4
              DO 12 K = KQ+1,KQ+4
                  DQ(K) = SIGIN*DQ(K)
                  DP(K) = SIGIN*(DP(K) + SI*Q(K))
   12         CONTINUE
   15     CONTINUE
          DQ(13) = DQ(13)*SIGIN
          IF (ITFAC.NE.0) THEN
              TFAC = TFAC*SIGIN
              ITFAC = 0
          END IF
      END IF
*
      IF (ICALL.EQ.0) RETURN
*
*       Find minimum distance index.
      RMIN = 1.0D+20
      DO 18 L = 1,3
          IF (R(L).LT.RMIN) THEN
              IM = L
              RMIN = R(L)
          END IF
   18 CONTINUE
*
*       Determine osculating pericentre of close pair (first call only).
      ITER = 0
   20 K = 1 + 4*(IM - 1)
      IF (IM.EQ.1) THEN
          K1 = I1
          K2 = I2
          RP = R(2)
      ELSE
          IF (IM.EQ.2) THEN
              K1 = I2
              K2 = I3
              RP = MIN(R(1),R(3))
          ELSE
              K1 = I3
              K2 = I4
              RP = R(2)
          END IF
      END IF
*
*       Obtain pericentre for small perturbations (ignore mass effect).
      GI = (R(IM)/RP)**3
      IF (GI.LT.0.005) THEN
          CALL PERI(Q(K),DQ(K),DQ(13),M(K1),M(K2),QPERI)
      ELSE
          QPERI = R(IM)
      END IF
*
*       Compare pericentre with previous mutual distances.
      RIJ(K1,K2) = MIN(RIJ(K1,K2),QPERI)
      RIJ(K2,K1) = MIN(RIJ(K2,K1),QPERI)
*
*       Check minimum two-body distance and switch off indicator.
      RCOLL = MIN(RCOLL,QPERI)
      ICALL = 0
*
*       Set scalar product, current distance & Kepler time near collision.
      IF (QPERI.LT.MAX(SIZE(K1),SIZE(K2))) THEN
          RPR = 0.0D0
          DO 25 J = K,K+3
              RPR = RPR + Q(J)*DQ(J)
   25     CONTINUE
          RI = R(IM)
          DT = RI*SQRT(RI/(M(K1) + M(K2)))
      END IF
*
*       Treat second pair similarly unless middle distance is smallest.
      IF (ITER.EQ.0) THEN
          IM = 4 - IM
          ITER = 1
          IF (IM.NE.2) GO TO 20
      END IF
*
*       Check for star collisions.
      IF (RCOLL.LT.MAX(SIZE(K1),SIZE(K2))) THEN
*
*       Save minimum configuration.
          DO 30 K = 1,12
              QK(K) = Q(K)
              PK(K) = P(K)
   30     CONTINUE
*
*       Activate collision indicator & B-S step selector (first time).
          IF (ICOLL.EQ.0) THEN
              ICOLL = -1
              JC = 1
          ELSE
*       Reset B-S step selector and specify termination if RMIN < 2*RCOLL.
              IF (RMIN.LT.2.0*RCOLL) THEN
                  JC = 0
                  ICOLL = 1
              END IF
          END IF
*
*       Include pericentre ratio in new step to damp oscillations.
          DS = DT/DQ(13)*(1.0 - RCOLL/RI)
*       Impose negative sign beyond pericentre.
          IF (RPR.GT.0.0D0) DS = -DS
*       Save reduced step for immediate use by DIFSY4.
          DSC = DS
      END IF
*
      RETURN
*
      END
