      SUBROUTINE DEFINE
*
*
*       Definition of parameters, options & counters.
*       ----------------------------------------------
*
*
*       Input parameters
*       ****************
*
*       --------------------------------------------------------------------
*       KSTART  Control index (1: new run; >1: restart; 3, 4, 5: new params).
*       TCOMP   Maximum computing time in minutes (saved in CPU).
*
*       N       Total particle number (singles + binary c.m.; < NMAX - 2).
*       NFIX    Output frequency of data save or binaries (options 3 & 6).
*       NCRIT   Final particle number (alternative termination criterion).
*       NRAND   Random number sequence skip.
*       NRUN    Run identification index.
*
*       ETA     Time-step parameter for total force polynomial.
*       DTADJ   Time interval for parameter adjustment (in units of TCR).
*       DELTAT  Output time interval in units of the crossing time.
*       TCRIT   Termination time in units of the crossing time.
*       QE      Energy tolerance (restart if DE/E > 5*QE & KZ(2) > 1).
*       RBAR    Virial cluster radius in pc (set = 0 for isolated cluster).
*       ZMBAR   Mean mass in solar units (set > 0 for isolated cluster).
*
*       KZ(J)   Non-zero options for alternative paths (see table).
*
*       DTMIN   Time-step criterion for regularization search.
*       RMIN    Distance criterion for regularization search.
*       ETAU    Regularized time-step parameter (6.28/ETAU steps/orbit).
*       ECLOSE  Binding energy per unit mass for hard binary (positive).
*       GMIN    Relative two-body perturbation for unperturbed motion.
*       GMAX    Secondary termination parameter for soft KS binaries.
*
*       DELTAS  Output interval for binary search (in TCR; option 4).
*       ORBITS  Minimum periods for binary output (level 1).
*       GPRINT  Perturbation thresholds for binary output (9 levels).
*
*       ALPHAS  Power-law index for initial mass function (routine DATA).
*       BODY1   Maximum particle mass before scaling (KZ(20): solar mass).
*       BODYN   Minimum particle mass before scaling.
*       NBIN0   Number of primordial binaries (for IMF2 with KZ(20) > 1).
*
*       Q       Virial ratio (routine SCALE; Q = 0.5 for equilibrium).
*       VXROT   XY-velocity scaling factor (> 0 for solid-body rotation).
*       VZROT   Z-velocity scaling factor (not used if VXROT = 0).
*       RSPH2   Radius of reflecting sphere (option 29; units of RSCALE).
*
*       SIGMA0  Hot initial velocity in km/sec (routine HOTSYS; option 29).
*
*       NBIN    Number of primordial binaries (routine BINPOP; option 8).
*       SEMI    Max semi-major axis in model units (all equal if RANGE = 0).
*       ECC     Initial eccentricity (< 0 for thermal distribution).
*       RATIO   Mass ratio M1/(M1 + M2); (= 1.0: M1 = M2 = <M>; not #20 > 1).
*       RANGE   Range in SEMI for uniform logarithmic distribution (> 0).
*       NSKIP   Binary frequency of mass spectrum (#20 < 2; body #1 first).
*       IDORM   Indicator for dormant binaries (>0: merged components).
*
*       SEMI    Max semi-major axis in model units (all equal if RANGE = 0).
*       ECC     Initial eccentricity (< 0 for thermal distribution).
*       RATIO   Mass ratio (= 1.0: M1 = M2; random in [0.5-0.9]).
*       RANGE   Range in SEMI for uniform logarithmic distribution (> 0).
*       ICIRC   Circularization & collision check (not implemented yet).
*
*       GMG     Black hole mass (#14 = 2) routine XTRNL0.
*       RG0     Star cluster distance to BH.
*  
*       TINJ    First injection time (routine INTGRT, NSTEPI = 0); #11.
*       DTINJ   Injection time interval.
*  
*       RSTAR   Size of typical star in A.U. (routine INTIDE; option 27).
*       RTSTAR  Two-body separation in A.U. for tidal capture.
*       RSYNC   Size of synchronous binary orbit in A.U.
*       EPOCH   Evolutionary epoch (in 10**6 yrs) for mass-radius relation.
*
*       IMS     # idealized main-sequence stars (routine INTIDE; option 27).
*       IEV     # idealized evolved stars (< 0: radius = |IEV|*sqrt(m)*SU).
*       RMS     Scale factor for main-sequence radii (>0: fudge factor).
*       REV     Scale factor for evolved radii (initial size RSTAR).
*       ---------------------------------------------------------------------
*
*
*       Options KZ(J)
*       *************
*
*       ---------------------------------------------------------------------
*       1  COMMON save on unit 1 at end of run (=2: every 100*NMAX steps).
*       2  COMMON save on unit 2 at output (=1); restart if DE/E > 5*QE (=2).
*       3  Basic data on unit 3 at output time (frequency NFIX).
*       4  Binary diagnostics on unit 4 (# threshold levels = KZ(4) < 10).
*       5  Initial conditions (=0: uniform & isotropic; =1: Plummer).
*       6  Output of significant & regularized binaries (=1, 2, 3 & 4).
*       7  Lagrangian radii (>0: RSCALE; =2, 3, 4: output on unit 6 & 7).
*       8  Initial binaries (=1 & 3); (> 0: BINOUT; >2: BINDAT).
*       9  Individual bodies printed at output time (MIN(5**KZ9,NTOT)).
*      10  Diagnostic KS output (>0: begin KS; >1: end; >=3: each step).
*      11  Injection at tidal boundary RBOUND.
*      12  Cluster drag force.
*      13  Conservative time-step criterion for close encounters.
*      14  External force (=1: tidal field; =2: not implemented).
*      15  Triple, quad, chain (#30 > 0) or merger search (> 1: full output).
*      16  Updating of regularization parameters (RMIN, DTMIN & ECLOSE).
*      17  Modification of ETA (> 0) & ETAU (> 1) by tolerance QE.
*      18  Time-step from strict convergence of force polynomial (#18 = 1).
*      18  Primordial triples (#18 > 2).
*      19  Increase of output intervals (based on single particle energy).
*      20  Initial mass function (=1: Scalo; =2,4: Kroupa; =3,5: Eggleton).
*      21  Extra output line (MODEL #, TCOMP, DMIN, AMIN, RMAX).
*      22  Initial conditions on unit 10 (=1: output; =2: not implemented.
*      23  Escaper removal (>1: diagnostics in file ESC; >2: angles unit #6).
*      24  Initial conditions for subsystem (routine SCALE; KZ(24) = #).
*      25  Partial reflection of KS binary orbit (GAMMA < GMIN; suppressed).
*      26  Slow-down of two-body motion (>=1: KS binary; =2: chain binary).
*      27  Two-body tidal interaction (=1, 2, 3: polytropic index 1.5, 2, 3).
*      28  Center of mass correction after energy check (highly recommended).
*      29  Boundary reflection for hot system.
*      30  Chain regularization (>=2: main output; >2: diagnostic output).
*       ---------------------------------------------------------------------
*
*
*       Output counters
*       ***************
*
*       -------------------------------------------------------------------
*       NSTEPI  N-body integration steps.
*       NSTEPU  Regularized integration steps.
*       NICONV  Irregular step reduction (force convergence test).
*       NBREF   Boundary reflections (option 29).
*       NBSTAT  Diagnostic data on binary interactions (option 4; inactive).
*       NBDUM1  Not used at present.
*       NKSTRY  Two-body regularization attempts.
*       NKSREG  Total KS regularizations.
*       NKSHYP  Hyperbolic KS regularizations.
*       NKSPER  Unperturbed KS binary orbits.
*       NPRECT  Initialization of NKSPER after exceeding 2*10**9.
*       NKSREF  Partial reflections of KS binary (option 25).
*       NKSMOD  Slow KS motion restarts (option 26).
*       NTTRY   Search for three-body & four-body regularization or mergers.
*       NTRIP   Three-body regularizations (option 15).
*       NQUAD   Four-body regularizations (option 15).
*       NMERG   Mergers of stable triples or quadruples (option 15).
*       NSTEPT  Triple regularization integration steps (option 15).
*       NSTEPQ  Quadruple regularization integration steps (option 15).
*       NSTEPC  Chain regularization steps (# DIFSY calls).
*       NDISS   Tidal dissipation at pericentre (option 27).
*       NTIDE   Tidal captures from hyperbolic orbits (option 27).
*       NSYNC   Number of synchronous binaries (a < RSYNC; option 27).
*       NCOLL   Stellar collisions (option 27).
*       NSESC   Escaped single particles (option 23).
*       NBESC   Escaped binaries (option 23).
*       NMESC   Escaped mergers (option 15 and 23).
*       -------------------------------------------------------------------
*
*
*       Output counters NCOUNT(J)
*       *************************
*
*       ---------------------------------------------------------------------
*       1  N-body integration steps.
*       3  Regularized integration steps.
*       7  Two-body regularization attempts.
*       8  Total KS regularizations.
*       9  Hyperbolic regularizations.
*      10  Initializations of NCOUNT(13) after exceeding 2*10**9.
*      13  Unperturbed binary orbits.
*      14  Partial reflections of KS binary.
*      21  Search for three-body & four-body regularization or mergers.
*      22  Three-body regularizations.
*      23  Four-body regularizations.
*      24  Mergers of stable triples or quadruples.   
*      25  Slow KS motion restarts.
*      26  Diagnostic data on binary interactions (option 4).
*      27  Tidal dissipation at pericentre.
*      28  Stellar collisions.
*      29  Boundary reflections.
*       ---------------------------------------------------------------------
*
*
      RETURN
*
      END
