      SUBROUTINE CMF(I,IPAIR,XI,YI,ZI,FIRR)
*
*
*       Total c.m. force.
*       -----------------
*
      INCLUDE 'common3.h'
      COMMON/EXTRA/  RPERT2,I1,I2
      REAL*8  FIRR(3),FP(6)
*
*
*       Obtain the global coordinates at current time.
      CALL KSRES(IPAIR,I1,I2,0.0D0)
*
*       Initialize the perturbing force.
      DO 1 K = 1,6
          FP(K) = 0.0D0
    1 CONTINUE
      XI1 = X(1,I1)
      YI1 = X(2,I1)
      ZI1 = X(3,I1)
      XI2 = X(1,I2)
      YI2 = X(2,I2)
      ZI2 = X(3,I2)
*       Scalars for total force loop.
      KDUM = 0
*
*       Force loop treats case I > N and any other c.m. perturbers.
      DO 10 JDUM = IFIRST,NTOT
          IF (JDUM.EQ.I) GO TO 10
          K = JDUM
          A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*       Decide appropriate summation (c.m. approximation or components).
          IF (K.LE.N.AND.RIJ2.GT.RPERT2) GO TO 8
          IF (K.LE.N) GO TO 4
*
          J = K - N
*       See whether c.m. approximation applies (ignore unperturbed case).
          IF (RIJ2.GT.CMSEP2*R(J)**2) THEN
              IF (RIJ2.GT.RPERT2) GO TO 8
              GO TO 4 
          END IF
*
*       Resolve components of pair #J.
          CALL KSRES(J,J1,J2,RIJ2)
          KDUM = J1
          K = KDUM
*       Check c.m. approximation for current pair.
          IF (RIJ2.GT.RPERT2) GO TO 6
*
    4     A1 = X(1,K) - XI1
          A2 = X(2,K) - YI1
          A3 = X(3,K) - ZI1
          RIJ2 = A1*A1 + A2*A2 + A3*A3
          A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FP(1) = FP(1) + A1*A6
          FP(2) = FP(2) + A2*A6
          FP(3) = FP(3) + A3*A6
*       Perturbation on first component.
*
          A1 = X(1,K) - XI2
          A2 = X(2,K) - YI2
          A3 = X(3,K) - ZI2
          RIJ2 = A1*A1 + A2*A2 + A3*A3
          A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FP(4) = FP(4) + A1*A6
          FP(5) = FP(5) + A2*A6
          FP(6) = FP(6) + A3*A6
*       Perturbation on second component.
*
          IF (K.GT.KDUM) GO TO 10
          K = K + 1
          GO TO 4
*
*       Sum over individual components of pair #J using c.m. approximation.
    6     A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*       Adopt c.m. approximation outside the effective perturber sphere.
    8     A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) + A1*A6
          FIRR(2) = FIRR(2) + A2*A6
          FIRR(3) = FIRR(3) + A3*A6
          IF (K.EQ.KDUM) THEN
              K = K + 1
              GO TO 6
          END IF
   10 CONTINUE
*
*       Add perturbation on the components to the c.m. contributions.
      IF (FP(1).NE.0.0D0) THEN
          BODYIN = 1.0/BODY(I)
          DO 20 K = 1,3
              FIRR(K) = (BODY(I1)*FP(K) + BODY(I2)*FP(K+3))*BODYIN +
     &                                                           FIRR(K)
   20     CONTINUE
      END IF
*
*       Check force correction due to regularized chain.
      IF (NCH.GT.0) THEN
          CALL KCPERT(I,I1,FIRR)
      END IF 
*
      RETURN
*
      END
