      SUBROUTINE CHMOD(ISUB,KCASE)
*
*
*       Modification of chain member(s).
*       --------------------------------
*
      INCLUDE 'common3.h'
      PARAMETER  (NMX=10,NMX2=2*NMX,NMX3=3*NMX,NMX4=4*NMX,
     &            NMX8=8*NMX,NMXm=NMX*(NMX-1)/2)
      REAL*8  M,MASS,MC,MIJ,MKK,XCM(3),VCM(3)
      INTEGER  ISORT(NMX)
      COMMON/CHAIN1/  XCH(NMX3),VCH(NMX3),M(NMX),
     &                ZZ(NMX3),WC(NMX3),MC(NMX),
     &                XI(NMX3),PI(NMX3),MASS,RINV(NMXm),RSUM,MKK(NMX),
     &                MIJ(NMX,NMX),TKK(NMX),TK1(NMX),INAME(NMX),NN
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      COMMON/CPERT/  RGRAV,GPERT,IPERT,NPERT
      COMMON/CHREG/  TIMEC,TMAX,RMAXC,CM(10),NAMEC(6),NSTEP1,KZ27,KZ30
      COMMON/CLUMP/   BODYS(NCMAX,5),T0S(5),TS(5),STEPS(5),RMAXS(5),
     &                NAMES(NCMAX,5),ISYS(5)
      COMMON/CCOLL2/  QK(NMX4),PK(NMX4),RIK(NMX,NMX),SIZE(NMX),VSTAR1,
     &                ECOLL1,RCOLL,QPERI,ISTAR(NMX),ICOLL,ISYNC,NDISS1
      COMMON/INCOND/  X4(3,NMX),XDOT4(3,NMX)
*
*
*       Identify the dominant perturber (skip if none or NN >= 4).
      ITRY = 0
      JCLOSE = 0
    1 NNB = LISTC(1)
      IF (NNB.EQ.0.OR.NN.GE.5) GO TO 10
      PMAX = 0.0
      DO 5 L = 2,NNB+1
          J = LISTC(L)
          RIJ2 = (X(1,J) - X(1,ICH))**2 + (X(2,J) - X(2,ICH))**2 +
     &                                    (X(3,J) - X(3,ICH))**2
          PIJ = BODY(J)/(RIJ2*SQRT(RIJ2))
          IF (PIJ.GT.PMAX) THEN
              PMAX = PIJ
              RJMIN2 = RIJ2
              JCLOSE = J
          END IF
    5 CONTINUE
*
*       Form the scalar product R*V for sign of radial velocity.
      RDOT = (X(1,JCLOSE) - X(1,ICH))*(XDOT(1,JCLOSE) - XDOT(1,ICH)) +
     &       (X(2,JCLOSE) - X(2,ICH))*(XDOT(2,JCLOSE) - XDOT(2,ICH)) +
     &       (X(3,JCLOSE) - X(3,ICH))*(XDOT(3,JCLOSE) - XDOT(3,ICH))
*
*       Check acceptance criteria (RSUM + RIJ < RMIN & RDOT < 0; RIJ < RSUM).
      RIJ = SQRT(RJMIN2)
      IF (RIJ.GT.10.0*RSUM.OR.NAME(JCLOSE).LT.0) GO TO 10
      RDOT = RDOT/RIJ
*       Include additional criteria (V^2 < VP^2/2; JCL > N & RIJ < 1.5*RSUM).
      IF ((RSUM + RIJ.LT.RMIN.AND.RDOT.LT.0.0).OR.
     &    (RIJ.LT.2.0*RMIN.AND.RDOT**2.LT.(MASS + BODY(JCLOSE))/RIJ).OR.
     &    (JCLOSE.GT.N.AND.RIJ.LT.1.5*RSUM.AND.RDOT.LT.0.0)) THEN
          RSUM = RSUM + RIJ
          IF (KZ(30).GT.1) THEN
              WRITE (6,8)  JCLOSE, NAME(JCLOSE), RIJ, RSUM, RDOT
    8         FORMAT (' ABSORB:    JCLOSE NMJ RIJ RSUM RDOT ',
     &                             2I4,1P,3E9.1)
          END IF
*
*       Absorb the perturber (single particle or binary).
          CALL ABSORB(ISUB)
*
*       Activate indicator for new chain treatment and try a second search.
          KCASE = 1
          ITRY = ITRY + 1
          IF (ITRY.EQ.1) GO TO 1
      END IF
*
*       Exit if any particles have been absorbed.
   10 IF (ITRY.GT.0) GO TO 50
*
*       Place index of the smallest INVERSE distance in ISORT(1).
      CALL HPSORT(NN-1,RINV,ISORT)
*
*       Determine index of escaper candidate (single star or binary).
      KCASE = 0
      JESC = 0
*       Distinguish two cases of each type (beginning & end of chain).
      IF (ISORT(1).EQ.1) THEN
          IESC = INAME(1)
          KCASE = 1
      ELSE IF (ISORT(1).EQ.NN-1) THEN
          IESC = INAME(NN)
          KCASE = 1
*       Check for possible binary escaper (NN = 3 implies single escaper).
      ELSE IF (ISORT(1).EQ.2) THEN
          IESC = INAME(1)
          JESC = INAME(2)
          IBIN = 1
*       Switch binary index in case last separation is smallest (NN = 4).
          IF (RINV(1).LT.RINV(NN-1)) IBIN = NN - 1
          KCASE = 2
      ELSE IF (ISORT(1).EQ.NN-2) THEN
          IESC = INAME(NN-1)
          JESC = INAME(NN)
          IBIN = NN - 1
          KCASE = 2
      END IF
*
*       Include safety test for abnormal configuration.
      IF (KCASE.EQ.0) GO TO 60
*
      IF (KZ(30).GT.2) THEN
          WRITE (6,12)  IESC, JESC, NSTEP1, ISORT(1),
     &                  (1.0/RINV(K),K=1,NN-1)
   12     FORMAT (' CHMOD:    IESC JESC # ISORT1 R ',2I3,I5,I3,1P,5E9.1)
      END IF
*
*       Copy chain variables to standard form.
      LK = 0
      DO 20 L = 1,NCH
          DO 15 K = 1,3
              LK = LK + 1
              X4(K,L) = XCH(LK)
              XDOT4(K,L) = VCH(LK)
   15     CONTINUE
   20 CONTINUE
*
*       First check case of escaping binary (JESC > 0 & RB < RJB/4).
      IF (JESC.GT.0) THEN
          RB = 1.0/RINV(IBIN)
          JBIN = IBIN + 1
          IF (IBIN.EQ.NN - 1) JBIN = IBIN - 1
          RJB = 1.0/RINV(JBIN)
          IF (RB.GT.0.25*RJB) GO TO 30
      ELSE
          RB = 0.0
          GO TO 30
      END IF
*
*       Form coordinates & velocities of escaping binary (local c.m. frame).
      BCM = BODYC(IESC) + BODYC(JESC)
      RI2 = 0.0
      RDOT = 0.0
      VREL2 = 0.0
      DO 25 K = 1,3
          XCM(K) = (BODYC(IESC)*X4(K,IESC) + BODYC(JESC)*X4(K,JESC))/BCM
          VCM(K) = (BODYC(IESC)*XDOT4(K,IESC) +
     &              BODYC(JESC)*XDOT4(K,JESC))/BCM
          RI2 = RI2 + XCM(K)**2
          RDOT = RDOT + XCM(K)*VCM(K)
          VREL2 = VREL2 + (XDOT4(K,IESC) - XDOT4(K,JESC))**2
   25 CONTINUE
*
*       Convert to relative distance & radial velocity w.r.t. inner part.
      FAC = BODY(ICH)/(BODY(ICH) - BCM)
      RI = SQRT(RI2)
      RDOT = FAC*RDOT/RI
      RI = FAC*RI
      RESC = MAX(3.0*RGRAV,0.5*RSUM)
      AINV = 2.0/RB - VREL2/BCM
      EB = -0.5*BODYC(IESC)*BODYC(JESC)*AINV
*
*       Employ parabolic escape criterion (terminate if RI > RMIN & NCH < 5).
      IF (RI.GT.RESC.AND.RDOT.GT.0.0) THEN
          IF (RDOT**2.LT.2.0*BODY(ICH)/RI) THEN
*       Define effective perturbation using half remaining size.
              GB = 2.0*BCM/BODY(ICH)*(0.5*(RSUM - RJB - RB)/RI)**3
*       Enforce termination if RI > RMIN and NCH <= 4.
              IF (RI.GT.RMIN.AND.NCH.LE.4) THEN
                  KCASE = -1
                  GO TO 50
*       Accept escape of binary for small effective perturbation (NCH > 4).
              ELSE IF (GB.LT.1.0D-04.AND.NCH.GT.4) THEN
                  WRITE (6,28)  IESC, JESC, NAMEC(IESC), NAMEC(JESC),
     &                          RI, RDOT**2, 2.0*BODY(ICH)/RI, RB
                  CM(9) = CM(9) - EB
                  GO TO 40
              ELSE
*       Check splitting into two KS solutions (R1 + R3 < R2/5 & RDOT > VC).
                  IF (NCH.EQ.4) THEN
                      R13 = 1.0/RINV(1) + 1.0/RINV(3)
                      VC2 = RDOT**2*RI/BODY(ICH)
                      IF (R13.LT.0.2/RINV(2).AND.VC2.GT.1.0) THEN
                          KCASE = -1
                          GO TO 50
                      END IF
                  END IF
                  KCASE = 0
                  GO TO 60
              END IF
          ELSE
              WRITE (6,28)  IESC, JESC, NAMEC(IESC), NAMEC(JESC),
     &                      RI, RDOT**2, 2.0*BODY(ICH)/RI, RB
   28         FORMAT (' CHAIN ESCAPE:    IESC JESC NM RI RDOT2 2*M/R ',
     &                                   'RB',I4,I3,2I6,1P,4E9.1)
*       Enforce termination (KCASE < 0) if NCH <= 4 (final membership <= 2).
              IF (NCH.LE.4) THEN
                  KCASE = -1
                  GO TO 50
              END IF
              CM(9) = CM(9) - EB
              GO TO 40
          END IF
      ELSE
          KCASE = 0
          GO TO 60
      END IF
*
*       Form relative distance and radial velocity for single particle.
   30 RI = SQRT(X4(1,IESC)**2 + X4(2,IESC)**2 + X4(3,IESC)**2)
      RDOT = X4(1,IESC)*XDOT4(1,IESC) + X4(2,IESC)*XDOT4(2,IESC) +
     &                                  X4(3,IESC)*XDOT4(3,IESC)
      FAC = BODY(ICH)/(BODY(ICH) - BODYC(IESC))
      RDOT = FAC*RDOT/RI
      RI = FAC*RI
*
*       Check approximate escape criterion outside 2*RGRAV.
      IF (RI.GT.2.0*RGRAV.AND.RDOT.GT.0.0) THEN
          IF (RDOT**2.LT.2.0*BODY(ICH)/RI) THEN
              ER = 0.5*RDOT**2 - BODY(ICH)/RI
              RX = -BODY(ICH)/ER
              IF (ER.LT.0.0.AND.RX.LT.2.0*RMIN) THEN
                  KCASE = 0
                  GO TO 60
              END IF
              IF (RI.GT.RMIN) THEN
*       Decide between termination or removal for sub-parabolic motion.
                  IF (NN.LE.4) THEN
                      KCASE = -1
                      GO TO 60
                  ELSE
                      KCASE = 1
                      GO TO 32
                  END IF
              ELSE
                  KCASE = 0
                  GO TO 60
              END IF
*       Extend escaper separation up to RMIN/2 for memberships > 3.
          ELSE IF (NN.GE.4) THEN
              IM = ISORT(1)
*       Include three-body stability test for distant fourth body.
              IF (1.0/RINV(IM).GT.0.75*RSUM) THEN
                  CALL CHSTAB(ITERM)
                  IF (ITERM.LT.0) THEN
                      KCASE = -1
                      GO TO 60
                  END IF
              END IF
              IF (1.0/RINV(IM).LT.0.5*RMIN) THEN
                  KCASE = 0
                  GO TO 60
              END IF
          END IF
*
*       Check that escaper is well separated (ratio > 3).
          IM = ISORT(1)
          RR = RSUM - 1.0/RINV(IM)
          RATIO = 1.0/(RINV(IM)*RR)
          IF (RATIO.LT.3.0.AND.RSUM.LT.RMIN) THEN
              KCASE = 0
              GO TO 60
          END IF
*
   32     IF (KZ(30).GT.1) THEN
              WRITE (6,35)  IESC, NAMEC(IESC), RI, RDOT**2,
     &                      2.0*BODY(ICH)/RI
   35         FORMAT (' CHAIN ESCAPE:    IESC NM RI RDOT2 2*M/R ',
     &                                   I3,I6,1P,3E9.1)
          END IF
*       Ensure single body is removed in case of wide binary.
          JESC = 0
      ELSE
          KCASE = 0
          GO TO 60
      END IF
*
*       Reduce chain membership (NCH > 3) or specify termination.
   40 IF (NCH.GT.3) THEN
*       Subtract largest chain distance from system size (also binary).
          IM = ISORT(1)
          RSUM = RSUM - 1.0/RINV(IM) - RB
          CALL REDUCE(IESC,JESC,ISUB)
      ELSE
          KCASE = -1
      END IF
*
*       Set phase indicator < 0 to ensure new NLIST in routine INTGRT.
   50 IPHASE = -1
*
   60 RETURN
*
      END
