      SUBROUTINE CHF(I,XI,YI,ZI,FIRR)
*
*
*       Irregular force on chain c.m.
*       -----------------------------
*
      INCLUDE 'common3.h'
      REAL*8  M,MASS,MC,MIJ,MKK
      PARAMETER  (NMX=10,NMX2=2*NMX,NMX3=3*NMX,NMX4=4*NMX,
     &            NMX8=8*NMX,NMXm=NMX*(NMX-1)/2)
      COMMON/CHAIN1/  XCH(NMX3),VCH(NMX3),M(NMX),
     &                ZZ(NMX3),WC(NMX3),MC(NMX),
     &                XJ(NMX3),PI(NMX3),MASS,RINV(NMXm),RSUM,MKK(NMX),
     &                MIJ(NMX,NMX),TKK(NMX),TK1(NMX),INAME(NMX),NN
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      REAL*8  FIRR(3),FP(3*NCMAX),FPSUM(3)
*
*
*       Perform perturber list updating and prediction of chain coordinates.
      CALL CHLIST(ICH)
      CALL XCPRED(0)
*
*       First subtract all perturber forces with respect to single body #ICH.
      NPC = LISTC(1) + 1
      JDUM = 0
      DO 1 L = 2,NPC
          J = LISTC(L)
          A1 = X(1,J) - XI
          A2 = X(2,J) - YI
          A3 = X(3,J) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
          IF (J.LE.N) GO TO 99
          JP = J - N
*       See whether c.m. approximation applies (ignore unperturbed case).
          IF (RIJ2.GT.CMSEP2*R(JP)**2) GO TO 99
*       Resolve components of pair #JP.
          CALL KSRES(JP,J1,J2,RIJ2)
          J = J1
          JDUM = J1
*       Sum over individual KS components.
   95     A1 = X(1,J) - XI
          A2 = X(2,J) - YI
          A3 = X(3,J) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
   99     A6 = BODY(J)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) - A1*A6
          FIRR(2) = FIRR(2) - A2*A6
          FIRR(3) = FIRR(3) - A3*A6
          IF (J.EQ.JDUM) THEN
              J = J + 1
              GO TO 95
          END IF
    1 CONTINUE
*
*       Initialize the perturbing force components and vectorial sum.
      DO 2 K = 1,3*NCH
          FP(K) = 0.0D0
    2 CONTINUE
      DO 3 K = 1,3
          FPSUM(K) = 0.0D0
    3 CONTINUE
*
*       Set perturber distance and calculate force for chain c.m.
      RPERT2 = CMSEP2*(0.5*RSUM)**2
      KDUM = 0
      IM1 = 0
      DO 10 L = 2,NPC
          K = LISTC(L)
          A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*
*       Decide appropriate summation (c.m. approximation or components).
          IF (K.LE.N) THEN
              IF (RIJ2.GT.RPERT2) GO TO 9
              GO TO 4
          ELSE IF (RIJ2.LT.CMSEP2*R(K-N)**2) THEN
              KDUM = 2*(K - N) - 1
              K = KDUM
          END IF
*
*       Check c.m. approximation for current pair.
          IF (RIJ2.GT.RPERT2) GO TO 8
*
*       Obtain perturbation on each component.
    4     DO 6 IM = 1,NCH
              IM1 = 3*(IM - 1)
    5         A1 = X(1,K) - XC(1,IM)
              A2 = X(2,K) - XC(2,IM)
              A3 = X(3,K) - XC(3,IM)
              RIJ2 = A1*A1 + A2*A2 + A3*A3
              A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
              FP(IM1+1) = FP(IM1+1) + A1*A6
              FP(IM1+2) = FP(IM1+2) + A2*A6
              FP(IM1+3) = FP(IM1+3) + A3*A6
*
              IF (K.EQ.KDUM) THEN
                  K = K + 1
                  GO TO 5
              ELSE
                  IF (KDUM.GT.0) K = KDUM
              END IF
    6     CONTINUE
*
*       Reset dummy index after use (otherwise bug with two KS pairs).
          KDUM = 0
          GO TO 10
*
*       Sum over individual components of pair #J using c.m. approximation.
    8     A1 = X(1,K) - XI
          A2 = X(2,K) - YI
          A3 = X(3,K) - ZI
          RIJ2 = A1*A1 + A2*A2 + A3*A3
*       Adopt c.m. approximation outside the effective perturber sphere.
    9     A6 = BODY(K)/(RIJ2*SQRT(RIJ2))
          FIRR(1) = FIRR(1) + A1*A6
          FIRR(2) = FIRR(2) + A2*A6
          FIRR(3) = FIRR(3) + A3*A6
          IF (K.EQ.KDUM) THEN
              K = K + 1
              GO TO 8
          END IF
   10 CONTINUE
*
*       Add perturbation on the components to the c.m. contributions.
      IF (IM1.GT.0) THEN
*       Sum individual perturbations.
          DO 20 L = 1,NCH
              L1 = 3*(L - 1)
              DO 15 K = 1,3
                  FPSUM(K) = FPSUM(K) + BODYC(L)*FP(L1+K)
   15         CONTINUE
   20     CONTINUE
*
*       Include total perturbation with c.m. force.
          BODYIN = 1.0/BODY(I)
          DO 30 K = 1,3
              FIRR(K) = FPSUM(K)*BODYIN + FIRR(K)
   30     CONTINUE
      END IF
*
      RETURN
*
      END
