      SUBROUTINE ABSORB(ISUB)
*
*
*       Absorption of chain member(s).
*       -----------------------------
*
      INCLUDE 'common3.h'
      PARAMETER  (NMX=10,NMX2=2*NMX,NMX3=3*NMX,NMX4=4*NMX,
     &            NMX8=8*NMX,NMXm=NMX*(NMX-1)/2)
      REAL*8  M,MASS,MC,MIJ,MKK,XCM(3),VCM(3)
      COMMON/CHAIN1/  XCH(NMX3),VCH(NMX3),M(NMX),
     &                ZZ(NMX3),WC(NMX3),MC(NMX),
     &                XI(NMX3),PI(NMX3),MASS,RINV(NMXm),RSUM,MKK(NMX),
     &                MIJ(NMX,NMX),TKK(NMX),TK1(NMX),INAME(NMX),NN
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      COMMON/CHREG/  TIMEC,TMAX,RMAXC,CM(10),NAMEC(6),NSTEP1,KZ27,KZ30
      COMMON/CLUMP/   BODYS(NCMAX,5),T0S(5),TS(5),STEPS(5),RMAXS(5),
     &                NAMES(NCMAX,5),ISYS(5)
      COMMON/CCOLL2/  QK(NMX4),PK(NMX4),RIK(NMX,NMX),SIZE(NMX),VSTAR1,
     &                ECOLL1,RCOLL,QPERI,ISTAR(NMX),ICOLL,ISYNC,NDISS1
      COMMON/INCOND/  X4(3,NMX),XDOT4(3,NMX)
*
*
*       Update the global time (becomes current time).
      TIME = T0S(ISUB) + TIMEC
*
*       Increase membership of chain (JCLOSE: single body or KS pair).
      NCH0 = NCH
      CALL SETSYS
*
*       Improve coordinates & velocities of c.m. body to order F3DOT.
      CALL XVPRED(ICH,-1)
*
      SUM = 0.0
      DO 5 K = 1,3
          XCM(K) = 0.0
          VCM(K) = 0.0
    5 CONTINUE
*
*       Accumulate mass-weighted moments of absorbed particle(s).
      DO 15 L = NCH0+1,NCH
          J = JLIST(L)
          SUM = SUM + BODY(J)
          DO 10 K = 1,3
              XCM(K) = XCM(K) + BODY(J)*X(K,J)
              VCM(K) = VCM(K) + BODY(J)*XDOT(K,J)
   10     CONTINUE
   15 CONTINUE
*
*       Form combined c.m. of old chain and new perturber(s).
      DO 20 K = 1,3
          XCM(K) = (BODY(ICH)*X(K,ICH) + XCM(K))/(BODY(ICH) + SUM)
          VCM(K) = (BODY(ICH)*XDOT(K,ICH) + VCM(K))/(BODY(ICH) + SUM)
   20 CONTINUE
*
*       Define new relative coordinates & velocities and add to chain.
      LK = 3*NCH0
      DO 30 L = NCH0+1,NCH
          J = JLIST(L)
          DO 25 K = 1,3
              LK = LK + 1
              X4(K,L) = X(K,J) - XCM(K)
              XDOT4(K,L) = XDOT(K,J) - VCM(K)
              XCH(LK) = X4(K,L)
              VCH(LK) = XDOT4(K,L)
   25     CONTINUE
   30 CONTINUE
*
*       Re-define old chain variables with respect to new c.m.
      LK = 0
      DO 40 L = 1,NCH0
          DO 35 K = 1,3
              LK = LK + 1
              XCH(LK) = XCH(LK) - (XCM(K) - X(K,ICH))
              VCH(LK) = VCH(LK) - (VCM(K) - XDOT(K,ICH))
   35     CONTINUE
   40 CONTINUE
*
*       Create ghost particle(s) and remove from perturber lists.
      DO 50 L = NCH0+1,NCH
          J = JLIST(L)
          CALL GHOST(J)
   50 CONTINUE
*
*       Update total mass and initialize new c.m. body variables.
      BODY(ICH) = BODY(ICH) + SUM
      CM(7) = BODY(ICH)
      T0(ICH) = TIME
      DO 60 K = 1,3
          X(K,ICH) = XCM(K)
          X0(K,ICH) = XCM(K)
          XDOT(K,ICH) = VCM(K)
          X0DOT(K,ICH) = VCM(K)
   60 CONTINUE
*
*       Perform re-initialization of c.m. polynomials & perturber list.
      CALL REINIT(ISUB)
*
*       Check centre of mass condition.
      DO 80 K = 1,6
          CM(K) = 0.0
   80 CONTINUE
*
      LK = 0
      DO 90 L = 1,NCH
          DO 85 K = 1,3
              LK = LK + 1
              CM(K) = CM(K) + BODYC(L)*XCH(LK)
              CM(K+3) = CM(K+3) + BODYC(L)*VCH(LK)
   85     CONTINUE
   90 CONTINUE
*
      DO 95 K = 1,6
          CM(K) = CM(K)/CM(7)
   95 CONTINUE
*
*     WRITE (6,99)  (CM(K),K=1,6)
*  99 FORMAT (' ABSORB:   CM ',1P,6E9.1)
*
      RETURN
*
      END
